/*
 * Decompiled with CFR 0.152.
 */
package com.minecrafttas.lotas_light.config;

import com.minecrafttas.lotas_light.LoTASLight;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.InvalidPropertiesFormatException;
import java.util.Properties;
import org.apache.logging.log4j.Logger;

public abstract class AbstractDataFile {
    protected final Logger logger;
    protected final Path file;
    protected final String name;
    protected final String comment;
    protected Properties properties;

    protected AbstractDataFile(Logger logger, Path file, String name, String comment) {
        this.logger = logger;
        this.file = file;
        this.name = name;
        this.comment = comment;
        this.properties = new Properties();
    }

    protected void createDirectory(Path file) {
        try {
            Files.createDirectories(file.getParent(), new FileAttribute[0]);
        }
        catch (IOException e) {
            LoTASLight.LOGGER.catching((Throwable)e);
        }
    }

    public void load() {
        if (Files.exists(this.file, new LinkOption[0])) {
            this.load(this.file);
        }
    }

    public void load(Path file) {
        Properties newProp = new Properties();
        try {
            InputStream fis = Files.newInputStream(file, new OpenOption[0]);
            newProp.load(fis);
            fis.close();
        }
        catch (InvalidPropertiesFormatException e) {
            this.logger.error("The {} file could not be read", (Object)this.name, (Object)e);
            return;
        }
        catch (FileNotFoundException e) {
            this.logger.warn("No {} file found: {}", (Object)this.name, (Object)file);
            return;
        }
        catch (IOException e) {
            this.logger.error("An error occured while reading the {} file", (Object)file, (Object)e);
            return;
        }
        this.properties = newProp;
    }

    public void loadFromXML() {
        if (Files.exists(this.file, new LinkOption[0])) {
            this.loadFromXML(this.file);
        }
    }

    public void loadFromXML(Path file) {
        Properties newProp = new Properties();
        try {
            InputStream fis = Files.newInputStream(file, new OpenOption[0]);
            newProp.loadFromXML(fis);
            fis.close();
        }
        catch (InvalidPropertiesFormatException e) {
            this.logger.error("The {} file could not be read", (Object)this.name, (Object)e);
            return;
        }
        catch (FileNotFoundException e) {
            this.logger.warn("No {} file found: {}", (Object)this.name, (Object)file);
            return;
        }
        catch (IOException e) {
            this.logger.error("An error occured while reading the {} file", (Object)file, (Object)e);
            return;
        }
        this.properties = newProp;
    }

    public void save() {
        this.save(this.file);
    }

    public void save(Path file) {
        this.createDirectory(file);
        try {
            OutputStream fos = Files.newOutputStream(file, new OpenOption[0]);
            this.properties.store(fos, this.comment);
            fos.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void saveToXML() {
        this.saveToXML(this.file);
    }

    public void saveToXML(Path file) {
        this.createDirectory(file);
        try {
            OutputStream fos = Files.newOutputStream(file, new OpenOption[0]);
            this.properties.storeToXML(fos, this.comment, "UTF-8");
            fos.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

