/*
 * Decompiled with CFR 0.152.
 */
package com.minecrafttas.lotas_light.config;

import com.minecrafttas.lotas_light.LoTASLight;
import com.minecrafttas.lotas_light.config.AbstractDataFile;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Properties;

public class Configuration
extends AbstractDataFile {
    public Configuration(String comment, Path configFile) {
        super(LoTASLight.LOGGER, configFile, "config", comment);
    }

    @Override
    public void loadFromXML() {
        if (Files.exists(this.file, new LinkOption[0])) {
            this.loadFromXML(this.file);
        }
        if (this.properties == null || !Files.exists(this.file, new LinkOption[0])) {
            this.properties = this.generateDefault();
            this.saveToXML();
        }
    }

    public Properties generateDefault() {
        Properties newProperties = new Properties();
        for (ConfigOptions configOption : ConfigOptions.values()) {
            newProperties.put(configOption.getConfigKey(), configOption.getDefaultValue());
        }
        return newProperties;
    }

    public String get(ConfigOptions configOption) {
        return this.properties.getProperty(configOption.getConfigKey(), configOption.getDefaultValue());
    }

    public int getInt(ConfigOptions configOption) {
        return Integer.parseInt(this.get(configOption));
    }

    public boolean getBoolean(ConfigOptions configOption) {
        return Boolean.parseBoolean(this.get(configOption));
    }

    public boolean has(ConfigOptions configOption) {
        return this.properties.contains(configOption.getConfigKey());
    }

    public void set(ConfigOptions configOption, String value) {
        if (this.properties == null) {
            throw new NullPointerException("Config needs to be loaded first, before trying to set a value");
        }
        this.properties.setProperty(configOption.getConfigKey(), value);
        this.saveToXML();
    }

    public void set(ConfigOptions configOption, int value) {
        String val = Integer.toString(value);
        this.set(configOption, val);
    }

    public void set(ConfigOptions configOption, boolean value) {
        String val = Boolean.toString(value);
        this.set(configOption, val);
    }

    public void reset(ConfigOptions configOption) {
        this.set(configOption, configOption.getDefaultValue());
    }

    public void delete(ConfigOptions configOption) {
        this.properties.remove((Object)configOption);
        this.saveToXML();
    }

    public boolean toggle(ConfigOptions tickrateIndicator) {
        boolean newVal = !this.getBoolean(tickrateIndicator);
        this.set(tickrateIndicator, newVal);
        return newVal;
    }

    public static enum ConfigOptions {
        DEFAULT_TICKRATE("trcDefaultTickrate", "20.0"),
        TICKRATE_SHOW_MESSAGES("trcShowMessages", "true"),
        SAVESTATE_SHOW_CONTROLS("savestateShowControls", "true"),
        TICKRATE_INDICATOR("trcTickIndicator", "true"),
        TICKRATE_PAUSE_INDICATOR("trcPauseIndicator", "true"),
        TICKRATE_INDICATOR_LOCATION("trcIndicatorLocation", "top_right");

        private String key;
        private String defaultValue;

        private ConfigOptions(String key, String defaultValue) {
            this.key = key;
            this.defaultValue = defaultValue;
        }

        public String getConfigKey() {
            return this.key;
        }

        public String getDefaultValue() {
            return this.defaultValue;
        }
    }
}

