/*
 * Decompiled with CFR 0.152.
 */
package com.minecrafttas.lotas_light;

import com.minecrafttas.lotas_light.LoTASLight;
import com.minecrafttas.lotas_light.config.Configuration;
import com.minecrafttas.lotas_light.duck.Tickratechanger;
import com.minecrafttas.lotas_light.event.EventClientGameLoop;
import com.minecrafttas.lotas_light.event.EventOnClientJoinServer;
import com.minecrafttas.lotas_light.event.HudRenderEffectsCallback;
import com.minecrafttas.lotas_light.event.HudRenderExperienceCallback;
import com.minecrafttas.lotas_light.keybind.KeybindManager;
import com.minecrafttas.lotas_light.savestates.SavestateHandler;
import com.minecrafttas.lotas_light.savestates.gui.SavestateDoneGui;
import com.minecrafttas.lotas_light.savestates.gui.SavestateGui;
import com.minecrafttas.lotas_light.savestates.gui.SavestateRenameGui;
import com.mojang.blaze3d.systems.RenderSystem;
import java.nio.file.Path;
import net.fabricmc.api.ClientModInitializer;
import net.fabricmc.fabric.api.client.event.lifecycle.v1.ClientTickEvents;
import net.minecraft.class_1074;
import net.minecraft.class_1132;
import net.minecraft.class_124;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3218;
import net.minecraft.class_332;
import net.minecraft.class_424;
import net.minecraft.class_437;
import net.minecraft.class_442;
import net.minecraft.class_638;
import net.minecraft.class_8915;
import net.minecraft.class_8921;

public class LoTASLightClient
implements ClientModInitializer {
    private KeybindManager keybindManager = new KeybindManager(KeybindManager::isKeyDownExceptTextField);
    private float[] rates = new float[]{0.1f, 0.2f, 0.5f, 1.0f, 2.0f, 5.0f, 10.0f, 20.0f, 40.0f, 100.0f};
    private short rateIndex = (short)7;
    private Path configpath;
    public static Configuration config;
    private boolean showHint = true;
    private boolean showTickIndicator;
    public static boolean dupe;

    public void onInitializeClient() {
        class_310 mc = class_310.method_1551();
        this.configpath = mc.field_1697.toPath().resolve("config/lotas-light.cfg");
        config = new Configuration("LoTAS-Light config", this.configpath);
        config.loadFromXML();
        LoTASLight.startTickrate = Float.valueOf(Float.parseFloat(config.get(Configuration.ConfigOptions.DEFAULT_TICKRATE)));
        this.rateIndex = this.findClosestRateIndex(LoTASLight.startTickrate.floatValue());
        this.registerKeybindings();
        EventOnClientJoinServer.EVENT.register(player -> {
            if (LoTASLight.savestateHandler.loadStateComplete != null) {
                LoTASLight.savestateHandler.loadStateComplete.run();
                LoTASLight.savestateHandler.loadStateComplete = null;
            }
        });
        ClientTickEvents.START_CLIENT_TICK.register(client -> {
            this.showTickIndicator = !this.showTickIndicator;
        });
        HudRenderExperienceCallback.EVENT.register(this::drawHud);
        HudRenderEffectsCallback.EVENT.register(this::afterDrawEffects);
    }

    private void registerKeybindings() {
        this.keybindManager.registerKeybind(new KeybindManager.Keybind("key.lotaslight.increaseTickrate", "keycategory.lotaslight.lotaslight", 46, this::increaseTickrate));
        this.keybindManager.registerKeybind(new KeybindManager.Keybind("key.lotaslight.decreaseTickrate", "keycategory.lotaslight.lotaslight", 44, this::decreaseTickrate));
        this.keybindManager.registerKeybind(new KeybindManager.Keybind("key.lotaslight.freezeTickrate", "keycategory.lotaslight.lotaslight", 297, this::freezeTickrate, KeybindManager::isKeyDown));
        this.keybindManager.registerKeybind(new KeybindManager.Keybind("key.lotaslight.advanceTickrate", "keycategory.lotaslight.lotaslight", 298, this::advanceTickrate, KeybindManager::isKeyDown));
        this.keybindManager.registerKeybind(new KeybindManager.Keybind("key.lotaslight.savestate", "keycategory.lotaslight.lotaslight", 74, this::savestate));
        this.keybindManager.registerKeybind(new KeybindManager.Keybind("key.lotaslight.loadstate", "keycategory.lotaslight.lotaslight", 75, this::loadstate));
        this.keybindManager.registerKeybind(new KeybindManager.Keybind("key.lotaslight.duping", "keycategory.lotaslight.lotaslight", 79, this::dupe));
        EventClientGameLoop.EVENT.register(this.keybindManager::onRunClientGameLoop);
    }

    private void increaseTickrate(class_310 client) {
        if (client.field_1687 == null) {
            return;
        }
        class_1132 server = client.method_1576();
        if (server == null) {
            return;
        }
        class_8915 serverTickrateChanger = server.method_54833();
        this.rateIndex = this.findClosestRateIndex(serverTickrateChanger.method_54748());
        this.rateIndex = (short)(this.rateIndex + 1);
        this.rateIndex = (short)Math.clamp((long)this.rateIndex, 0, this.rates.length - 1);
        float tickrate = this.rates[this.rateIndex];
        if (config.getBoolean(Configuration.ConfigOptions.TICKRATE_SHOW_MESSAGES)) {
            if (this.showHint) {
                this.showHint = false;
                client.field_1705.method_1743().method_1812((class_2561)class_2561.method_43469((String)"msg.lotaslight.turnOff", (Object[])new Object[]{Float.valueOf(tickrate)}).method_27692(class_124.field_1054));
            }
            client.field_1705.method_1743().method_1812((class_2561)class_2561.method_43469((String)"msg.lotaslight.setTickrate", (Object[])new Object[]{Float.valueOf(tickrate)}));
        }
        serverTickrateChanger.method_54671(tickrate);
    }

    private void decreaseTickrate(class_310 client) {
        if (client.field_1687 == null) {
            return;
        }
        class_1132 server = client.method_1576();
        if (server == null) {
            return;
        }
        class_8915 serverTickrateChanger = server.method_54833();
        this.rateIndex = this.findClosestRateIndex(serverTickrateChanger.method_54748());
        this.rateIndex = (short)(this.rateIndex - 1);
        this.rateIndex = (short)Math.clamp((long)this.rateIndex, 0, this.rates.length - 1);
        float tickrate = this.rates[this.rateIndex];
        if (config.getBoolean(Configuration.ConfigOptions.TICKRATE_SHOW_MESSAGES)) {
            if (this.showHint) {
                this.showHint = false;
                client.field_1705.method_1743().method_1812((class_2561)class_2561.method_43469((String)"msg.lotaslight.turnOff", (Object[])new Object[]{Float.valueOf(tickrate)}).method_27692(class_124.field_1054));
            }
            client.field_1705.method_1743().method_1812((class_2561)class_2561.method_43469((String)"msg.lotaslight.setTickrate", (Object[])new Object[]{Float.valueOf(tickrate)}));
        }
        serverTickrateChanger.method_54671(tickrate);
    }

    private void freezeTickrate(class_310 client) {
        if (client.field_1687 == null) {
            return;
        }
        class_1132 server = client.method_1576();
        if (server == null) {
            return;
        }
        class_8915 serverTickrateManager = server.method_54833();
        Tickratechanger serverTickrateChanger = (Tickratechanger)serverTickrateManager;
        boolean enable = serverTickrateManager.method_54748() != 0.0f;
        serverTickrateChanger.enableTickrate0(enable);
    }

    private void advanceTickrate(class_310 client) {
        if (client.field_1687 == null) {
            return;
        }
        class_8921 clientTickrateManager = client.field_1687.method_54719();
        class_1132 server = client.method_1576();
        if (server == null) {
            return;
        }
        class_8915 serverTickrateManager = server.method_54833();
        Tickratechanger clientTickrateChanger = (Tickratechanger)clientTickrateManager;
        Tickratechanger serverTickrateChanger = (Tickratechanger)serverTickrateManager;
        clientTickrateChanger.advanceTick();
        serverTickrateChanger.advanceTick();
    }

    private void drawHud(class_332 context, float deltaTicks) {
        RenderSystem.enableBlend();
        context.method_51422(1.0f, 1.0f, 1.0f, 0.2f);
        context.method_25290(new class_2960("lotaslight", "potion.png"), class_310.method_1551().method_22683().method_4486() / 2 - 10, class_310.method_1551().method_22683().method_4502() - 50, 0.0f, 0.0f, 20, 20, 20, 20);
        context.method_51422(1.0f, 1.0f, 1.0f, 1.0f);
        RenderSystem.disableBlend();
    }

    private void afterDrawEffects(class_332 context, float deltaTicks) {
        float uvCoordinate;
        class_310 mc = class_310.method_1551();
        class_638 level = mc.field_1687;
        if (level == null) {
            return;
        }
        class_8921 tickrateChanger = level.method_54719();
        IndicatorLocation location = IndicatorLocation.valueOf(config.get(Configuration.ConfigOptions.TICKRATE_INDICATOR_LOCATION).toUpperCase());
        if (config.getBoolean(Configuration.ConfigOptions.TICKRATE_INDICATOR) && tickrateChanger.method_54748() <= 5.0f && this.showTickIndicator) {
            uvCoordinate = 0.0f;
            this.renderIcon(location, uvCoordinate, context);
        }
        if (config.getBoolean(Configuration.ConfigOptions.TICKRATE_PAUSE_INDICATOR) && tickrateChanger.method_54748() == 0.0f) {
            uvCoordinate = 16.0f;
            this.renderIcon(location, uvCoordinate, context);
        }
    }

    private void renderIcon(IndicatorLocation location, float uvCoordinate, class_332 context) {
        class_2960 streamIcons = new class_2960("lotaslight", "stream_indicator.png");
        int x = 0;
        int y = 0;
        switch (location.ordinal()) {
            case 0: {
                x = 1;
                y = 1;
                break;
            }
            case 1: {
                x = 1;
                y = context.method_51443() - 17;
                break;
            }
            case 3: {
                x = context.method_51421() - 17;
                y = context.method_51443() - 17;
                break;
            }
            default: {
                x = context.method_51421() - 17;
                y = 1;
            }
        }
        context.method_25290(streamIcons, x, y, uvCoordinate, uvCoordinate, 16, 16, 16, 64);
    }

    private void savestate(class_310 mc) {
        class_1132 server = mc.method_1576();
        if (server == null) {
            return;
        }
        for (class_3218 level : server.method_3738()) {
            level.field_13957 = true;
        }
        SavestateHandler.SavestateCallback renameCallback = paths -> {
            int index = paths.getSavestate().getIndex();
            mc.execute(() -> mc.method_1507((class_437)new SavestateRenameGui((class_2561)class_2561.method_43471((String)"gui.lotaslight.savestate.save.name"), (class_2561)class_2561.method_43469((String)"gui.lotaslight.savestate.save.rename", (Object[])new Object[]{class_2561.method_43470((String)Integer.toString(index)).method_27692(class_124.field_1075)}).method_27692(class_124.field_1060), index)));
        };
        mc.method_1507((class_437)new SavestateGui((class_2561)class_2561.method_43471((String)"gui.lotaslight.savestate.save.name"), (class_2561)class_2561.method_43471((String)"gui.lotaslight.savestate.save.start").method_27692(class_124.field_1054)));
        mc.method_1576().method_19537(() -> {
            try {
                LoTASLight.savestateHandler.saveState(renameCallback, new SavestateHandler.SavestateFlags[0]);
            }
            catch (Exception e) {
                LoTASLight.LOGGER.catching((Throwable)e);
                mc.execute(() -> {
                    String message = e.getMessage();
                    if (message == null || message.isEmpty()) {
                        message = class_1074.method_4662((String)"msg.lotaslight.savestate.failure", (Object[])new Object[]{e.toString()});
                    }
                    mc.field_1705.method_1743().method_1812((class_2561)class_2561.method_43470((String)message).method_27692(class_124.field_1061));
                    class_310.method_1551().method_1507(null);
                });
                LoTASLight.savestateHandler.resetState();
            }
        });
    }

    private void loadstate(class_310 mc) {
        class_1132 server = mc.method_1576();
        if (server == null) {
            return;
        }
        SavestateHandler.SavestateCallback doneLoadingCallback = paths -> mc.method_1507((class_437)new SavestateDoneGui((class_2561)class_2561.method_43471((String)"gui.lotaslight.savestate.load.name"), (class_2561)class_2561.method_43469((String)"gui.lotaslight.savestate.load.end", (Object[])new Object[]{class_2561.method_43470((String)paths.getSavestate().getName()).method_27692(class_124.field_1054), class_2561.method_43470((String)Integer.toString(paths.getSavestate().getIndex())).method_27692(class_124.field_1075)}).method_27692(class_124.field_1060)));
        try {
            for (class_3218 level : server.method_3738()) {
                level.field_13957 = true;
            }
            mc.method_1507((class_437)new SavestateGui((class_2561)class_2561.method_43471((String)"gui.lotaslight.savestate.load.name"), (class_2561)class_2561.method_43471((String)"gui.lotaslight.savestate.load.start").method_27692(class_124.field_1054)));
            LoTASLight.savestateHandler.loadState(doneLoadingCallback, new SavestateHandler.SavestateFlags[0]);
        }
        catch (Exception e) {
            LoTASLight.LOGGER.catching((Throwable)e);
            String message = e.getMessage();
            if (message == null || message.isEmpty()) {
                message = class_1074.method_4662((String)"msg.lotaslight.savestate.failure", (Object[])new Object[]{e.toString()});
            }
            mc.field_1705.method_1743().method_1812((class_2561)class_2561.method_43470((String)message).method_27692(class_124.field_1061));
            LoTASLight.savestateHandler.resetState();
            class_310.method_1551().method_1507(null);
        }
    }

    private void dupe(class_310 mc) {
        dupe = true;
        mc.field_1687.method_8525();
        mc.method_18096((class_437)new class_424((class_2561)class_2561.method_43471((String)"gui.lotaslight.duping.quitmsg")), false);
        mc.method_1507((class_437)new class_442());
    }

    private short findClosestRateIndex(float tickrate) {
        for (int i = 0; i < this.rates.length; ++i) {
            int iMinus1 = i - 1;
            float min = 0.0f;
            if (iMinus1 >= 0) {
                min = this.rates[iMinus1];
            }
            float max = this.rates[i];
            if (!(tickrate >= min) || !(tickrate < max)) continue;
            if (min == 0.0f) {
                return (short)i;
            }
            float distanceToMin = tickrate - min;
            float distanceToMax = max - tickrate;
            if (distanceToMin < distanceToMax) {
                return (short)iMinus1;
            }
            if (distanceToMax < distanceToMin) {
                return (short)i;
            }
            return (short)iMinus1;
        }
        return (short)(this.rates.length - 1);
    }

    private static enum IndicatorLocation {
        TOP_LEFT,
        BOTTOM_LEFT,
        TOP_RIGHT,
        BOTTOM_RIGHT;

    }
}

