/*
 * Decompiled with CFR 0.152.
 */
package com.minecrafttas.lotas_light.command;

import com.minecrafttas.lotas_light.LoTASLight;
import com.minecrafttas.lotas_light.LoTASLightClient;
import com.minecrafttas.lotas_light.config.Configuration;
import com.minecrafttas.lotas_light.savestates.SavestateHandler;
import com.minecrafttas.lotas_light.savestates.SavestateIndexer;
import com.minecrafttas.lotas_light.savestates.gui.SavestateDoneGui;
import com.minecrafttas.lotas_light.savestates.gui.SavestateGui;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import java.text.SimpleDateFormat;
import java.util.List;
import java.util.function.UnaryOperator;
import net.minecraft.class_1074;
import net.minecraft.class_124;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2558;
import net.minecraft.class_2561;
import net.minecraft.class_2564;
import net.minecraft.class_2568;
import net.minecraft.class_310;
import net.minecraft.class_3218;
import net.minecraft.class_437;
import net.minecraft.class_5250;

public class SavestateCommand {
    public static boolean once = true;

    public static void register(CommandDispatcher<class_2168> commandDispatcher) {
        commandDispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"savestate").executes(SavestateCommand::info)).then(((RequiredArgumentBuilder)class_2170.method_9244((String)"index", (ArgumentType)IntegerArgumentType.integer()).executes(SavestateCommand::infoIndex)).then(class_2170.method_9244((String)"amount", (ArgumentType)IntegerArgumentType.integer((int)0)).executes(SavestateCommand::infoIndexAmount)))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"save").executes(SavestateCommand::saveNew)).then(((RequiredArgumentBuilder)class_2170.method_9244((String)"index", (ArgumentType)IntegerArgumentType.integer((int)1)).executes(SavestateCommand::saveIndex)).then(class_2170.method_9244((String)"name", (ArgumentType)StringArgumentType.greedyString()).executes(SavestateCommand::saveNameIndex)))).then(class_2170.method_9244((String)"name", (ArgumentType)StringArgumentType.greedyString()).executes(SavestateCommand::saveName)))).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"load").executes(SavestateCommand::loadRecent)).then(class_2170.method_9244((String)"index", (ArgumentType)IntegerArgumentType.integer((int)0)).executes(SavestateCommand::loadIndex)))).then(class_2170.method_9247((String)"delete").then(((RequiredArgumentBuilder)class_2170.method_9244((String)"index", (ArgumentType)IntegerArgumentType.integer((int)1)).executes(SavestateCommand::delete)).then(((RequiredArgumentBuilder)class_2170.method_9244((String)"indexTo", (ArgumentType)IntegerArgumentType.integer((int)1)).executes(SavestateCommand::deleteMore)).then(class_2170.method_9247((String)"force").executes(SavestateCommand::deleteDis)))))).then(class_2170.method_9247((String)"reload").executes(SavestateCommand::reload))).then(class_2170.method_9247((String)"rename").then(class_2170.method_9244((String)"index", (ArgumentType)IntegerArgumentType.integer((int)0)).then(class_2170.method_9244((String)"name", (ArgumentType)StringArgumentType.greedyString()).executes(SavestateCommand::rename))))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"info").executes(SavestateCommand::info)).then(((RequiredArgumentBuilder)class_2170.method_9244((String)"index", (ArgumentType)IntegerArgumentType.integer((int)0)).executes(SavestateCommand::infoIndex)).then(class_2170.method_9244((String)"amount", (ArgumentType)IntegerArgumentType.integer((int)0)).executes(SavestateCommand::infoIndexAmount)))).then(class_2170.method_9247((String)"all").executes(SavestateCommand::infoAll))));
    }

    private static int saveNew(CommandContext<class_2168> context) {
        int index = -1;
        class_310 mc = class_310.method_1551();
        SavestateHandler.SavestateCallback doneSavingCallback = paths -> mc.method_1507((class_437)new SavestateDoneGui((class_2561)class_2561.method_43471((String)"gui.lotaslight.savestate.save.name"), (class_2561)class_2561.method_43469((String)"gui.lotaslight.savestate.save.end", (Object[])new Object[]{class_2561.method_43470((String)paths.getSavestate().getName()).method_27692(class_124.field_1054), class_2561.method_43470((String)Integer.toString(paths.getSavestate().getIndex())).method_27692(class_124.field_1075)}).method_27692(class_124.field_1060)));
        class_310.method_1551().execute(() -> {
            try {
                for (class_3218 level : class_310.method_1551().method_1576().method_3738()) {
                    level.field_13957 = true;
                }
                SavestateCommand.setSavestateScreen();
                LoTASLight.savestateHandler.saveState(index, doneSavingCallback, new SavestateHandler.SavestateFlags[0]);
            }
            catch (Exception e) {
                SavestateCommand.onFailure(context, e);
            }
        });
        return 0;
    }

    private static int saveIndex(CommandContext<class_2168> context) {
        int index = (Integer)context.getArgument("index", Integer.class);
        class_310 mc = class_310.method_1551();
        SavestateHandler.SavestateCallback doneSavingCallback = paths -> mc.method_1507((class_437)new SavestateDoneGui((class_2561)class_2561.method_43471((String)"gui.lotaslight.savestate.save.name"), (class_2561)class_2561.method_43469((String)"gui.lotaslight.savestate.save.end", (Object[])new Object[]{class_2561.method_43470((String)paths.getSavestate().getName()).method_27692(class_124.field_1054), class_2561.method_43470((String)Integer.toString(paths.getSavestate().getIndex())).method_27692(class_124.field_1075)}).method_27692(class_124.field_1060)));
        mc.execute(() -> {
            try {
                for (class_3218 level : class_310.method_1551().method_1576().method_3738()) {
                    level.field_13957 = true;
                }
                SavestateCommand.setSavestateScreen();
                LoTASLight.savestateHandler.saveState(index, doneSavingCallback, new SavestateHandler.SavestateFlags[0]);
            }
            catch (Exception e) {
                SavestateCommand.onFailure(context, e);
            }
        });
        return index;
    }

    private static int saveName(CommandContext<class_2168> context) {
        String name = (String)context.getArgument("name", String.class);
        class_310 mc = class_310.method_1551();
        if (name.equals("0")) {
            ((class_2168)context.getSource()).method_9213((class_2561)class_2561.method_43471((String)"msg.lotaslight.savestate.save.error2"));
            return -1;
        }
        SavestateHandler.SavestateCallback doneSavingCallback = paths -> mc.method_1507((class_437)new SavestateDoneGui((class_2561)class_2561.method_43471((String)"gui.lotaslight.savestate.save.name"), (class_2561)class_2561.method_43469((String)"gui.lotaslight.savestate.save.end", (Object[])new Object[]{class_2561.method_43470((String)paths.getSavestate().getName()).method_27692(class_124.field_1054), class_2561.method_43470((String)Integer.toString(paths.getSavestate().getIndex())).method_27692(class_124.field_1075)}).method_27692(class_124.field_1060)));
        mc.execute(() -> {
            try {
                for (class_3218 level : class_310.method_1551().method_1576().method_3738()) {
                    level.field_13957 = true;
                }
                SavestateCommand.setSavestateScreen();
                LoTASLight.savestateHandler.saveState(name, doneSavingCallback, new SavestateHandler.SavestateFlags[0]);
            }
            catch (Exception e) {
                SavestateCommand.onFailure(context, e);
            }
        });
        return 0;
    }

    private static int saveNameIndex(CommandContext<class_2168> context) {
        int index = (Integer)context.getArgument("index", Integer.class);
        String name = (String)context.getArgument("name", String.class);
        class_310 mc = class_310.method_1551();
        SavestateHandler.SavestateCallback doneSavingCallback = paths -> mc.method_1507((class_437)new SavestateDoneGui((class_2561)class_2561.method_43471((String)"gui.lotaslight.savestate.save.name"), (class_2561)class_2561.method_43469((String)"gui.lotaslight.savestate.save.end", (Object[])new Object[]{class_2561.method_43470((String)paths.getSavestate().getName()).method_27692(class_124.field_1054), class_2561.method_43470((String)Integer.toString(paths.getSavestate().getIndex())).method_27692(class_124.field_1075)}).method_27692(class_124.field_1060)));
        mc.execute(() -> {
            try {
                for (class_3218 level : class_310.method_1551().method_1576().method_3738()) {
                    level.field_13957 = true;
                }
                SavestateCommand.setSavestateScreen();
                LoTASLight.savestateHandler.saveState(index, name, doneSavingCallback, new SavestateHandler.SavestateFlags[0]);
            }
            catch (Exception e) {
                SavestateCommand.onFailure(context, e);
            }
        });
        return 0;
    }

    private static int loadRecent(CommandContext<class_2168> context) {
        int index = -1;
        class_310 mc = class_310.method_1551();
        SavestateHandler.SavestateCallback doneLoadingCallback = paths -> mc.method_1507((class_437)new SavestateDoneGui((class_2561)class_2561.method_43471((String)"gui.lotaslight.savestate.load.name"), (class_2561)class_2561.method_43469((String)"gui.lotaslight.savestate.load.end", (Object[])new Object[]{class_2561.method_43470((String)paths.getSavestate().getName()).method_27692(class_124.field_1054), class_2561.method_43470((String)Integer.toString(paths.getSavestate().getIndex())).method_27692(class_124.field_1075)}).method_27692(class_124.field_1060)));
        mc.execute(() -> {
            try {
                for (class_3218 level : class_310.method_1551().method_1576().method_3738()) {
                    level.field_13957 = true;
                }
                SavestateCommand.setLoadstateScreen();
                LoTASLight.savestateHandler.loadState(index, doneLoadingCallback, new SavestateHandler.SavestateFlags[0]);
            }
            catch (Exception e) {
                SavestateCommand.onFailure(context, e);
            }
        });
        return 0;
    }

    private static int loadIndex(CommandContext<class_2168> context) {
        int index = (Integer)context.getArgument("index", Integer.class);
        class_310 mc = class_310.method_1551();
        SavestateHandler.SavestateCallback doneLoadingCallback = paths -> mc.method_1507((class_437)new SavestateDoneGui((class_2561)class_2561.method_43471((String)"gui.lotaslight.savestate.load.name"), (class_2561)class_2561.method_43469((String)"gui.lotaslight.savestate.load.end", (Object[])new Object[]{class_2561.method_43470((String)paths.getSavestate().getName()).method_27692(class_124.field_1054), class_2561.method_43470((String)Integer.toString(paths.getSavestate().getIndex())).method_27692(class_124.field_1075)}).method_27692(class_124.field_1060)));
        mc.execute(() -> {
            try {
                for (class_3218 level : class_310.method_1551().method_1576().method_3738()) {
                    level.field_13957 = true;
                }
                SavestateCommand.setLoadstateScreen();
                LoTASLight.savestateHandler.loadState(index, doneLoadingCallback, new SavestateHandler.SavestateFlags[0]);
            }
            catch (Exception e) {
                SavestateCommand.onFailure(context, e);
            }
        });
        return index;
    }

    private static int delete(CommandContext<class_2168> context) {
        int index = (Integer)context.getArgument("index", Integer.class);
        try {
            LoTASLight.savestateHandler.delete(index, paths -> ((class_2168)context.getSource()).method_9226(() -> class_2561.method_43469((String)"msg.lotaslight.savestate.delete", (Object[])new Object[]{paths.getSavestate().getIndex()}).method_27692(class_124.field_1060), true));
        }
        catch (Exception e) {
            SavestateCommand.onFailure(context, e);
        }
        return index;
    }

    private static int deleteMore(CommandContext<class_2168> context) {
        int index = (Integer)context.getArgument("index", Integer.class);
        int indexTo = (Integer)context.getArgument("indexTo", Integer.class);
        int count = indexTo + 1 - index;
        if (count < 0) {
            ((class_2168)context.getSource()).method_9213((class_2561)class_2561.method_43469((String)"msg.lotaslight.savestate.deleteMore.error.negative", (Object[])new Object[]{count}));
            return -1;
        }
        String translationKey = "msg.lotaslight.savestate.deleteMore" + (count == 1 ? ".singular" : ".plural");
        class_5250 countComponent = class_2561.method_43470((String)Integer.toString(count)).method_27692(class_124.field_1061);
        class_5250 confirmationComponent = class_2564.method_10885((class_2561)class_2561.method_43469((String)"msg.lotaslight.savestate.deleteMore.clickable", (Object[])new Object[]{true}).method_27694(style -> style.method_10958(SavestateCommand.createClickEvent(class_2558.class_2559.field_11750, String.format("/savestate delete %s %s force", index, indexTo))).method_10949(SavestateCommand.createHoverEvent((class_2568.class_5247<class_2561>)class_2568.class_5247.field_24342, (class_2561)class_2561.method_43471((String)"msg.lotaslight.savestate.deleteMore.hover").method_27692(class_124.field_1079))))).method_27692(class_124.field_1060);
        ((class_2168)context.getSource()).method_9226(() -> SavestateCommand.lambda$deleteMore$15(translationKey, (class_2561)countComponent, (class_2561)confirmationComponent), true);
        return index;
    }

    private static int deleteDis(CommandContext<class_2168> context) {
        int index = (Integer)context.getArgument("index", Integer.class);
        int indexTo = (Integer)context.getArgument("indexTo", Integer.class);
        SavestateHandler.SavestateCallback cb = paths -> ((class_2168)context.getSource()).method_9226(() -> class_2561.method_43469((String)"msg.lotaslight.savestate.delete", (Object[])new Object[]{paths.getSavestate().getIndex()}).method_27692(class_124.field_1060), true);
        SavestateIndexer.ErrorRunnable onErr = exception -> SavestateCommand.onFailure(context, exception);
        LoTASLight.savestateHandler.delete(index, indexTo, cb, onErr);
        return index;
    }

    private static int reload(CommandContext<class_2168> context) {
        once = true;
        ((class_2168)context.getSource()).method_9226(() -> class_2561.method_43471((String)"msg.lotaslight.savestate.reload").method_27692(class_124.field_1060), true);
        LoTASLight.savestateHandler.reload();
        return 0;
    }

    private static int info(CommandContext<class_2168> context) {
        SavestateCommand.showInfo(context);
        return 0;
    }

    private static int infoAll(CommandContext<class_2168> context) {
        SavestateCommand.showInfo(context, -1, 0);
        return 0;
    }

    private static int infoIndex(CommandContext<class_2168> context) {
        int index = (Integer)context.getArgument("index", Integer.class);
        SavestateCommand.showInfo(context, index, null);
        return 0;
    }

    private static int infoIndexAmount(CommandContext<class_2168> context) {
        int index = (Integer)context.getArgument("index", Integer.class);
        int amount = (Integer)context.getArgument("amount", Integer.class);
        SavestateCommand.showInfo(context, index, amount);
        return 0;
    }

    private static int rename(CommandContext<class_2168> context) {
        int index = (Integer)context.getArgument("index", Integer.class);
        String name = (String)context.getArgument("name", String.class);
        SavestateHandler.SavestateCallback cb = paths -> ((class_2168)context.getSource()).method_9226(() -> class_2561.method_43469((String)"msg.lotaslight.savestate.rename", (Object[])new Object[]{class_2561.method_43470((String)Integer.toString(paths.getSavestate().getIndex())).method_27692(class_124.field_1075), class_2561.method_43470((String)paths.getSavestate().getName()).method_27692(class_124.field_1054)}).method_27692(class_124.field_1060), true);
        try {
            LoTASLight.savestateHandler.rename(index, name, cb);
        }
        catch (Exception e) {
            SavestateCommand.onFailure(context, e);
        }
        return 0;
    }

    private static void onFailure(CommandContext<class_2168> context, Throwable e) {
        class_310.method_1551().method_63588(() -> class_310.method_1551().method_1507(null));
        ((class_2168)context.getSource()).method_9213((class_2561)class_2561.method_43470((String)e.getMessage()));
        LoTASLight.LOGGER.catching(e);
        LoTASLight.savestateHandler.resetState();
    }

    private static void setSavestateScreen() {
        class_310.method_1551().method_1507((class_437)new SavestateGui((class_2561)class_2561.method_43471((String)"gui.lotaslight.savestate.save.name"), (class_2561)class_2561.method_43471((String)"gui.lotaslight.savestate.save.start").method_27692(class_124.field_1054)));
    }

    private static void setLoadstateScreen() {
        class_310.method_1551().method_1507((class_437)new SavestateGui((class_2561)class_2561.method_43471((String)"gui.lotaslight.savestate.load.name"), (class_2561)class_2561.method_43471((String)"gui.lotaslight.savestate.load.start").method_27692(class_124.field_1054)));
    }

    private static void showInfo(CommandContext<class_2168> context) {
        SavestateCommand.showInfo(context, null, null);
    }

    private static void showInfo(CommandContext<class_2168> context, Integer indexToDisplay, Integer amount) {
        int currentIndex = LoTASLight.savestateHandler.getCurrentIndex();
        int size = LoTASLight.savestateHandler.size();
        if (indexToDisplay == null) {
            indexToDisplay = currentIndex;
        }
        if (amount == null) {
            amount = 10;
        }
        ((class_2168)context.getSource()).method_45068((class_2561)class_2561.method_43470((String)""));
        String format = class_1074.method_4662((String)"msg.lotaslight.savestate.dateformat", (Object[])new Object[0]);
        SimpleDateFormat dateFormat = new SimpleDateFormat(format);
        List<SavestateIndexer.Savestate> savestateList = LoTASLight.savestateHandler.getSavestateInfo(indexToDisplay, amount);
        if (savestateList.size() < size && once) {
            ((class_2168)context.getSource()).method_45068((class_2561)class_2561.method_43469((String)"gui.lotaslight.savestate.omitted", (Object[])new Object[]{"/savestate info all"}).method_27695(new class_124[]{class_124.field_1061, class_124.field_1056}));
            once = false;
        }
        for (SavestateIndexer.Savestate savestate : savestateList) {
            String index = savestate.getIndex() == null ? "" : Integer.toString(savestate.getIndex());
            boolean isCurrentIndex = savestate.getIndex() == currentIndex;
            String name = savestate.getName() == null ? "" : savestate.getName();
            String date = savestate.getDate() == null ? "" : dateFormat.format(savestate.getDate());
            class_124 indexColor = isCurrentIndex ? class_124.field_1075 : class_124.field_1078;
            class_124 nameColor = isCurrentIndex ? class_124.field_1068 : class_124.field_1080;
            class_124 dateColor = isCurrentIndex ? class_124.field_1075 : class_124.field_1062;
            class_124 saveColor = isCurrentIndex ? class_124.field_1076 : class_124.field_1064;
            class_124 deleteColor = isCurrentIndex ? class_124.field_1061 : class_124.field_1079;
            class_124 renameColor = isCurrentIndex ? class_124.field_1054 : class_124.field_1065;
            class_124 loadColor = isCurrentIndex ? class_124.field_1060 : class_124.field_1077;
            UnaryOperator hover = t -> t.method_10949(SavestateCommand.createHoverEvent((class_2568.class_5247<class_2561>)class_2568.class_5247.field_24342, (class_2561)class_2561.method_43470((String)date).method_27692(dateColor)));
            class_5250 msg = null;
            if (savestate instanceof SavestateIndexer.FailedSavestate) {
                SavestateIndexer.FailedSavestate failedSavestate = (SavestateIndexer.FailedSavestate)savestate;
                msg = class_2561.method_43469((String)"%s: %s%s", (Object[])new Object[]{class_2561.method_43470((String)index).method_27692(indexColor), class_2561.method_43470((String)name).method_27692(nameColor), class_2561.method_43469((String)"msg.lotaslight.savestate.info.error", (Object[])new Object[]{failedSavestate.getError().getMessage()}).method_27692(class_124.field_1061)}).method_27694(t -> t.method_10949(SavestateCommand.createHoverEvent((class_2568.class_5247<class_2561>)class_2568.class_5247.field_24342, (class_2561)class_2561.method_43470((String)date).method_27692(class_124.field_1065))));
            } else if (!LoTASLightClient.config.getBoolean(Configuration.ConfigOptions.SAVESTATE_SHOW_CONTROLS)) {
                msg = class_2561.method_43469((String)"%s: %s", (Object[])new Object[]{class_2561.method_43470((String)index).method_27692(indexColor), class_2561.method_43470((String)name).method_27692(nameColor)}).method_27694(hover);
            } else {
                class_5250 saveComponent = class_2561.method_43471((String)"msg.lotaslight.savestate.save.clickable").method_27692(saveColor).method_27694(t -> t.method_10958(SavestateCommand.createClickEvent(class_2558.class_2559.field_11745, String.format("/savestate save %s", index)))).method_27694(t -> t.method_10949(SavestateCommand.createHoverEvent((class_2568.class_5247<class_2561>)class_2568.class_5247.field_24342, (class_2561)class_2561.method_43469((String)"msg.lotaslight.savestate.save.hover", (Object[])new Object[]{name}).method_27692(saveColor))));
                class_5250 deleteComponent = class_2561.method_43471((String)"msg.lotaslight.savestate.delete.clickable").method_27692(deleteColor).method_27694(t -> t.method_10958(SavestateCommand.createClickEvent(class_2558.class_2559.field_11745, String.format("/savestate delete %s", index)))).method_27694(t -> t.method_10949(SavestateCommand.createHoverEvent((class_2568.class_5247<class_2561>)class_2568.class_5247.field_24342, (class_2561)class_2561.method_43469((String)"msg.lotaslight.savestate.delete.hover", (Object[])new Object[]{name}).method_27692(deleteColor))));
                class_5250 renameComponent = class_2561.method_43471((String)"msg.lotaslight.savestate.rename.clickable").method_27692(renameColor).method_27694(t -> t.method_10958(SavestateCommand.createClickEvent(class_2558.class_2559.field_11745, String.format("/savestate rename %s ", index)))).method_27694(t -> t.method_10949(SavestateCommand.createHoverEvent((class_2568.class_5247<class_2561>)class_2568.class_5247.field_24342, (class_2561)class_2561.method_43469((String)"msg.lotaslight.savestate.rename.hover", (Object[])new Object[]{name}).method_27692(renameColor))));
                class_5250 loadComponent = class_2561.method_43471((String)"msg.lotaslight.savestate.load.clickable").method_27692(loadColor).method_27694(t -> t.method_10958(SavestateCommand.createClickEvent(class_2558.class_2559.field_11745, String.format("/savestate load %s", index)))).method_27694(t -> t.method_10949(SavestateCommand.createHoverEvent((class_2568.class_5247<class_2561>)class_2568.class_5247.field_24342, (class_2561)class_2561.method_43469((String)"msg.lotaslight.savestate.load.hover", (Object[])new Object[]{name}).method_27692(loadColor))));
                msg = class_2561.method_43469((String)"%s: %s     %s %s %s %s", (Object[])new Object[]{class_2561.method_43470((String)index).method_27692(indexColor), class_2561.method_43470((String)name).method_27692(nameColor), SavestateCommand.wrap((class_2561)saveComponent, nameColor), SavestateCommand.wrap((class_2561)deleteComponent, nameColor), SavestateCommand.wrap((class_2561)renameComponent, nameColor), SavestateCommand.wrap((class_2561)loadComponent, nameColor)}).method_27694(hover);
            }
            ((class_2168)context.getSource()).method_45068((class_2561)msg);
        }
    }

    private static class_2558 createClickEvent(class_2558.class_2559 action, String command) {
        return new class_2558(action, command);
    }

    private static class_2568 createHoverEvent(class_2568.class_5247<class_2561> action, class_2561 component) {
        return new class_2568(action, (Object)component);
    }

    private static class_2561 wrap(class_2561 component, class_124 color) {
        return class_2564.method_10885((class_2561)component).method_27692(color);
    }

    private static /* synthetic */ class_2561 lambda$deleteMore$15(String translationKey, class_2561 countComponent, class_2561 confirmationComponent) {
        return class_2561.method_43469((String)translationKey, (Object[])new Object[]{countComponent, confirmationComponent}).method_27692(class_124.field_1054);
    }
}

