/*
 * Decompiled with CFR 0.152.
 */
package com.minecrafttas.lotas_light.savestates;

import com.minecrafttas.lotas_light.LoTASLight;
import com.minecrafttas.lotas_light.duck.StorageLock;
import com.minecrafttas.lotas_light.duck.Tickratechanger;
import com.minecrafttas.lotas_light.mixin.AccessorLevelStorage;
import com.minecrafttas.lotas_light.mixin.AccessorServerPlayer;
import com.minecrafttas.lotas_light.savestates.SavestateIndexer;
import com.minecrafttas.lotas_light.savestates.exceptions.LoadstateException;
import com.minecrafttas.lotas_light.savestates.exceptions.SavestateDeleteException;
import com.minecrafttas.lotas_light.savestates.exceptions.SavestateException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.List;
import net.minecraft.class_1074;
import net.minecraft.class_243;
import net.minecraft.class_310;
import net.minecraft.class_3218;
import net.minecraft.class_437;
import net.minecraft.class_442;
import net.minecraft.server.MinecraftServer;
import org.apache.logging.log4j.Logger;

public class SavestateHandler {
    private final Logger logger;
    private MinecraftServer server;
    private SavestateIndexer indexer;
    private String worldname;
    private State state = State.NONE;
    public Runnable loadStateComplete = null;
    public Runnable applyMotion = null;

    public SavestateHandler(Logger logger, MinecraftServer server) {
        this.logger = logger;
        this.setIndexer(server);
    }

    public void saveState(SavestateCallback cb, SavestateFlags ... options) throws Exception {
        this.saveState(-1, null, cb, options);
    }

    public void saveState(int index, SavestateCallback cb, SavestateFlags ... flags) throws Exception {
        this.saveState(index, null, cb, flags);
    }

    public void saveState(String name, SavestateCallback cb, SavestateFlags ... flags) throws Exception {
        this.saveState(-1, name, cb, flags);
    }

    public void saveState(int index, String name, SavestateCallback cb, SavestateFlags ... flags) throws Exception {
        if (this.state != State.NONE) {
            throw new SavestateException(class_1074.method_4662((String)String.format("msg.lotaslight.savestate.%s.error", this.state == State.SAVESTATING ? "save" : "load"), (Object[])new Object[0]));
        }
        this.logger.debug("Creating a savestate");
        this.state = State.SAVESTATING;
        List<SavestateFlags> flagList = Arrays.asList(flags);
        class_310 mc = class_310.method_1551();
        this.server = mc.method_1576();
        this.logger.trace("Save world & players");
        this.server.method_39218(true, true, true);
        while (this.server.method_39219()) {
        }
        this.indexer.getCurrentSavestate().motion = mc.field_1724.method_18798();
        this.logger.trace("Create new savestate index via indexer");
        SavestateIndexer.SavestatePaths paths = this.indexer.createSavestate(index, name, !this.shouldBlock(flagList, SavestateFlags.BLOCK_CHANGE_INDEX), mc.field_1724.method_18798());
        this.logger.debug("Source: {}, Target: {}", (Object)paths.getSourceFolder(), (Object)paths.getTargetFolder());
        this.logger.trace("Remove session.lock");
        StorageLock levelStorage = (StorageLock)((AccessorLevelStorage)this.server).getStorageSource();
        levelStorage.unlock();
        if (Files.exists(paths.getTargetFolder(), new LinkOption[0])) {
            this.logger.warn("Overwriting existing savestate");
            SavestateIndexer.deleteFolder(paths.getTargetFolder());
        }
        this.logger.trace("Copying folders");
        SavestateIndexer.copyFolder(paths.getSourceFolder(), paths.getTargetFolder());
        levelStorage.lock(paths.getSourceFolder());
        for (class_3218 level : this.server.method_3738()) {
            level.field_13957 = false;
        }
        this.state = State.NONE;
        if (cb != null) {
            cb.invoke(paths);
        }
    }

    public void loadState(SavestateCallback cb, SavestateFlags ... flags) throws Exception {
        this.loadState(-1, null, cb, flags);
    }

    public void loadState(int index, SavestateCallback cb, SavestateFlags ... flags) throws Exception {
        this.loadState(index, null, cb, flags);
    }

    public void loadState(String name, SavestateCallback cb, SavestateFlags ... flags) throws Exception {
        this.loadState(-1, name, cb, flags);
    }

    public void loadState(int index, String name, SavestateCallback cb, SavestateFlags ... flags) throws Exception {
        if (this.state != State.NONE) {
            throw new LoadstateException(class_1074.method_4662((String)String.format("msg.lotaslight.savestate.%s.error", this.state == State.SAVESTATING ? "save" : "load"), (Object[])new Object[0]));
        }
        this.state = State.LOADSTATING;
        List<SavestateFlags> flagList = Arrays.asList(flags);
        class_310 mc = class_310.method_1551();
        this.server = mc.method_1576();
        Tickratechanger trmServer = (Tickratechanger)this.server.method_54833();
        Tickratechanger trmClient = (Tickratechanger)mc.field_1687.method_54719();
        trmServer.disconnect();
        trmClient.disconnect();
        this.logger.trace("Load savestate index via indexer");
        SavestateIndexer.SavestatePaths paths = this.indexer.loadSavestate(index, !this.shouldBlock(flagList, SavestateFlags.BLOCK_CHANGE_INDEX));
        this.logger.debug("Source: {}, Target: {}", (Object)paths.getSourceFolder(), (Object)paths.getTargetFolder());
        mc.field_1687.method_8525();
        mc.method_18099();
        while (this.server.method_39219() || this.server.method_3806()) {
        }
        SavestateIndexer.deleteFolder(paths.getTargetFolder());
        this.logger.trace("Copying folders");
        SavestateIndexer.copyFolder(paths.getSourceFolder(), paths.getTargetFolder());
        mc.method_41735().method_57784(this.worldname, () -> mc.method_1507((class_437)new class_442()));
        for (class_3218 level : this.server.method_3738()) {
            level.field_13957 = false;
        }
        this.applyMotion = () -> {
            class_243 motion = this.indexer.getCurrentSavestate().motion;
            if (motion != null) {
                mc.field_1724.method_18799(motion);
            }
        };
        this.loadStateComplete = () -> {
            this.server = mc.method_1576();
            for (class_3218 level : this.server.method_3738()) {
                level.field_13957 = false;
            }
            this.server.method_3760().method_14571().forEach(serverplayer -> ((AccessorServerPlayer)serverplayer).setSpawnInvulnerableTime(0));
            if (LoTASLight.startTickrate.floatValue() == 0.0f) {
                mc.field_1687.method_54719().method_54671(0.0f);
                mc.method_1576().method_54833().method_54671(0.0f);
            }
            mc.field_1705.method_1743().method_1808(true);
            if (cb != null) {
                cb.invoke(paths);
            }
            this.state = State.NONE;
        };
    }

    public void delete(int index, SavestateCallback cb) throws Exception {
        if (this.state == State.SAVESTATING) {
            throw new SavestateDeleteException("msg.lotaslight.savestate.save.error");
        }
        if (this.state == State.LOADSTATING) {
            throw new SavestateDeleteException("msg.lotaslight.savestate.load.error");
        }
        SavestateIndexer.SavestatePaths paths = this.indexer.deleteSavestate(index);
        SavestateIndexer.deleteFolder(paths.getTargetFolder());
        cb.invoke(paths);
    }

    public void delete(int from, int to, SavestateCallback cb, SavestateIndexer.ErrorRunnable err) {
        if (this.state == State.SAVESTATING) {
            err.run(new SavestateDeleteException("msg.lotaslight.savestate.save.error"));
            return;
        }
        if (this.state == State.LOADSTATING) {
            err.run(new SavestateDeleteException("msg.lotaslight.savestate.load.error"));
            return;
        }
        SavestateIndexer.DeletionRunnable onDelete = paths -> {
            SavestateIndexer.deleteFolder(paths.getTargetFolder());
            cb.invoke(paths);
        };
        this.indexer.deleteMultipleSavestates(from, to, onDelete, err);
    }

    public void reload() {
        this.indexer.reload();
    }

    public State getState() {
        return this.state;
    }

    public int getCurrentIndex() {
        return this.indexer.getCurrentSavestate().index;
    }

    public List<SavestateIndexer.Savestate> getSavestateInfo() {
        return this.getSavestateInfo(-1, 10);
    }

    public List<SavestateIndexer.Savestate> getSavestateInfo(int index, int amount) {
        return this.indexer.getSavestateList(index, amount);
    }

    public int size() {
        return this.indexer.size();
    }

    private boolean shouldBlock(List<SavestateFlags> flagList, SavestateFlags flag) {
        return flagList.contains((Object)flag);
    }

    public void setIndexer(MinecraftServer server) {
        this.server = server;
        Path savesDir = server.method_3724() ? server.method_3831().resolve("saves") : server.method_3831();
        Path savestateBaseDir = savesDir.resolve("savestates");
        this.worldname = ((AccessorLevelStorage)server).getStorageSource().method_27005();
        this.logger.debug("Created savestate handler with saves: {}, savestates: {}, worldname: {}", (Object)savesDir, (Object)savestateBaseDir, (Object)this.worldname);
        this.indexer = new SavestateIndexer(this.logger, savesDir, savestateBaseDir, this.worldname);
    }

    public void resetState() {
        this.state = State.NONE;
    }

    public void rename(int index, String name) throws Exception {
        this.rename(index, name, null);
    }

    public void rename(int index, String name, SavestateCallback cb) throws Exception {
        SavestateIndexer.SavestatePaths paths = this.indexer.renameSavestate(index, name);
        if (cb != null) {
            cb.invoke(paths);
        }
    }

    public static enum State {
        SAVESTATING,
        LOADSTATING,
        NONE;

    }

    @FunctionalInterface
    public static interface SavestateCallback {
        public void invoke(SavestateIndexer.SavestatePaths var1);
    }

    public static enum SavestateFlags {
        BLOCK_CHANGE_INDEX,
        BLOCK_PAUSE_TICKRATE;

    }
}

