/*
 * Decompiled with CFR 0.152.
 */
package com.minecrafttas.lotas_light.keybind;

import com.minecrafttas.lotas_light.keybind.Keyboard;
import com.minecrafttas.lotas_light.keybind.Mouse;
import com.minecrafttas.lotas_light.mixin.AccessorKeyMapping;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import net.fabricmc.fabric.api.client.keybinding.v1.KeyBindingHelper;
import net.minecraft.class_156;
import net.minecraft.class_304;
import net.minecraft.class_310;
import net.minecraft.class_3675;
import net.minecraft.class_408;
import net.minecraft.class_498;

public class KeybindManager {
    private final IsKeyDownFunc defaultFunction;
    private static Map<class_304, Long> cooldownMap = new HashMap<class_304, Long>();
    private static final long cooldown = 250L;
    public static boolean focused;
    private List<Keybind> keybindings;

    public KeybindManager(IsKeyDownFunc defaultFunction) {
        this.defaultFunction = defaultFunction;
        this.keybindings = new ArrayList<Keybind>();
    }

    public void onRunClientGameLoop(class_310 mc) {
        for (Keybind keybind : this.keybindings) {
            IsKeyDownFunc keyDown = keybind.isKeyDownFunc != null ? keybind.isKeyDownFunc : this.defaultFunction;
            if (!keyDown.isKeyDown(keybind.vanillaKeyBinding)) continue;
            keybind.onKeyDown.accept(mc);
        }
    }

    public void registerKeybind(Keybind keybind) {
        this.keybindings.add(keybind);
        class_304 keyBinding = keybind.vanillaKeyBinding;
        KeyBindingHelper.registerKeyBinding((class_304)keyBinding);
    }

    public static boolean isKeyDown(class_304 keybind) {
        boolean down = false;
        class_3675.class_306 key = ((AccessorKeyMapping)keybind).getKey();
        class_3675.class_307 type = key.method_1442();
        int keycode = key.method_1444();
        boolean bl = down = type == class_3675.class_307.field_1668 ? Keyboard.isKeyDown(keycode) : Mouse.isKeyDown(keycode);
        if (down) {
            long currentTime = class_156.method_658();
            if (cooldownMap.containsKey(keybind)) {
                if (250L <= currentTime - cooldownMap.get(keybind)) {
                    cooldownMap.put(keybind, currentTime);
                    return true;
                }
                return false;
            }
            cooldownMap.put(keybind, currentTime);
            return true;
        }
        return false;
    }

    public static boolean isKeyDownExceptTextField(class_304 keybind) {
        class_310 mc = class_310.method_1551();
        if (mc.field_1755 instanceof class_408 || mc.field_1755 instanceof class_498 || focused && mc.field_1755 != null) {
            return false;
        }
        return KeybindManager.isKeyDown(keybind);
    }

    @FunctionalInterface
    public static interface IsKeyDownFunc {
        public boolean isKeyDown(class_304 var1);
    }

    public static class Keybind {
        public final class_304 vanillaKeyBinding;
        private final Consumer<class_310> onKeyDown;
        private final IsKeyDownFunc isKeyDownFunc;

        public Keybind(String name, String category, int defaultKey, Consumer<class_310> onKeyDown) {
            this(name, category, defaultKey, onKeyDown, null);
        }

        public Keybind(String name, String category, int defaultKey, Consumer<class_310> onKeyDown, IsKeyDownFunc func) {
            this.vanillaKeyBinding = new class_304(name, defaultKey, category);
            this.onKeyDown = onKeyDown;
            this.isKeyDownFunc = func;
        }

        public String toString() {
            return this.vanillaKeyBinding.method_1431();
        }
    }
}

