/*
 * Decompiled with CFR 0.152.
 */
package com.cleanroommc.fugue.transformer.loliasm;

import com.cleanroommc.fugue.common.Fugue;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import javassist.ClassPool;
import javassist.CtClass;
import top.outlands.foundation.IExplicitTransformer;
import zone.rong.loliasm.core.LoliLoadingPlugin;

public class JavaFixesTransformer
implements IExplicitTransformer {
    private boolean shouldRun() {
        String ver;
        try {
            ver = LoliLoadingPlugin.class.getField("VERSION").get(null).toString();
        }
        catch (IllegalAccessException | NoSuchFieldException e) {
            return false;
        }
        Fugue.LOGGER.info("Found lolasm version {}", (Object)ver);
        return Integer.parseInt(ver.split("\\.")[1]) > 28;
    }

    public byte[] transform(byte[] bytes) {
        if (this.shouldRun()) {
            return bytes;
        }
        try {
            ClassPool cp = ClassPool.getDefault();
            CtClass cc = cp.makeClass((InputStream)new ByteArrayInputStream(bytes));
            cc.getDeclaredMethod("run").setBody("{}");
            bytes = cc.toBytecode();
        }
        catch (Throwable t) {
            Fugue.LOGGER.error("Exception {} on {}", (Object)t, (Object)this.getClass().getSimpleName());
        }
        return bytes;
    }
}

