/*
 * Decompiled with CFR 0.152.
 */
package com.cleanroommc.fugue.transformer.universal;

import com.cleanroommc.fugue.common.Fugue;
import java.util.Map;
import java.util.Set;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.FieldVisitor;
import top.outlands.foundation.IExplicitTransformer;

public class FinalStripperTransformer
implements IExplicitTransformer {
    private final Map<String, String> targets;

    public FinalStripperTransformer(Map<String, String> targets) {
        this.targets = targets;
    }

    public byte[] transform(byte[] bytes) {
        ClassReader reader = new ClassReader(bytes);
        ClassWriter writer = new ClassWriter(0);
        CV cv = new CV((ClassVisitor)writer);
        reader.accept((ClassVisitor)cv, 0);
        return writer.toByteArray();
    }

    private class CV
    extends ClassVisitor {
        private Set<String> fields;
        private String className;

        public CV(ClassVisitor cv) {
            super(589824, cv);
        }

        public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
            String outerName = name.replace('/', '.');
            if (FinalStripperTransformer.this.targets.containsKey(outerName)) {
                this.fields = Set.of(FinalStripperTransformer.this.targets.get(outerName.replace('/', '.')).split("\\|"));
                this.className = outerName;
            }
            if (this.cv != null) {
                this.cv.visit(version, access, name, signature, superName, interfaces);
            }
        }

        public FieldVisitor visitField(int access, String name, String descriptor, String signature, Object value) {
            if (this.cv != null) {
                if (this.fields.contains(name)) {
                    Fugue.LOGGER.debug("Stripping final modifier of {} from {}", (Object)name, (Object)this.className.replace('/', '.'));
                    return this.cv.visitField(access & 0xFFFFFFEF, name, descriptor, signature, value);
                }
                return this.cv.visitField(access, name, descriptor, signature, value);
            }
            return null;
        }
    }
}

