/*
 * Decompiled with CFR 0.152.
 */
package com.cleanroommc.fugue.transformer.universal;

import com.cleanroommc.fugue.common.Fugue;
import java.util.Map;
import java.util.Set;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.FieldNode;
import top.outlands.foundation.IExplicitTransformer;

public class FinalStripperTransformer
implements IExplicitTransformer {
    private final Map<String, String> targets;

    public FinalStripperTransformer(Map<String, String> targets) {
        this.targets = targets;
    }

    public byte[] transform(byte[] bytes) {
        ClassNode classNode = new ClassNode();
        ClassReader classReader = new ClassReader(bytes);
        classReader.accept((ClassVisitor)classNode, 0);
        Set<String> fields = Set.of(this.targets.get(classNode.name.replace('/', '.')).split("\\|"));
        if (classNode.methods != null) {
            for (FieldNode fieldNode : classNode.fields) {
                if (!fields.contains(fieldNode.name)) continue;
                fieldNode.access &= 0xFFFFFFEF;
                Fugue.LOGGER.debug("Stripping final modifier of {} from {}", (Object)fieldNode.name, (Object)classNode.name.replace('/', '.'));
            }
        }
        ClassWriter classWriter = new ClassWriter(0);
        classNode.accept((ClassVisitor)classWriter);
        return classWriter.toByteArray();
    }
}

