/*
 * Decompiled with CFR 0.152.
 */
package com.cleanroommc.fugue.transformer.universal;

import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.InsnList;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.MethodNode;
import top.outlands.foundation.IExplicitTransformer;

public class ReflectFieldTransformer
implements IExplicitTransformer {
    private static final String OUR_REFLECTION_CLASS = "com/cleanroommc/hackery/ReflectionHackery";

    private static void replaceInstruction(InsnList insnList, MethodInsnNode oldNode, String methodName, String methodDescriptor) {
        insnList.set((AbstractInsnNode)oldNode, (AbstractInsnNode)new MethodInsnNode(184, OUR_REFLECTION_CLASS, methodName, methodDescriptor));
    }

    public byte[] transform(byte[] bytes) {
        ClassNode classNode = new ClassNode();
        ClassReader classReader = new ClassReader(bytes);
        classReader.accept((ClassVisitor)classNode, 0);
        if (classNode.methods != null) {
            for (MethodNode methodNode : classNode.methods) {
                InsnList instructions = methodNode.instructions;
                if (instructions == null) continue;
                for (AbstractInsnNode insnNode : instructions) {
                    if (insnNode.getOpcode() != 182 || !(insnNode instanceof MethodInsnNode)) continue;
                    MethodInsnNode methodInsnNode = (MethodInsnNode)insnNode;
                    if (!"java/lang/reflect/Field".equals(methodInsnNode.owner)) continue;
                    switch (methodInsnNode.name) {
                        case "set": {
                            ReflectFieldTransformer.replaceInstruction(instructions, methodInsnNode, "setField", "(Ljava/lang/reflect/Field;Ljava/lang/Object;Ljava/lang/Object;)V");
                            break;
                        }
                        case "get": {
                            ReflectFieldTransformer.replaceInstruction(instructions, methodInsnNode, "getField", "(Ljava/lang/reflect/Field;Ljava/lang/Object;)Ljava/lang/Object;");
                            break;
                        }
                        case "setBoolean": {
                            ReflectFieldTransformer.replaceInstruction(instructions, methodInsnNode, "setBooleanField", "(Ljava/lang/reflect/Field;Ljava/lang/Object;Z)V");
                            break;
                        }
                        case "getBoolean": {
                            ReflectFieldTransformer.replaceInstruction(instructions, methodInsnNode, "getBooleanField", "(Ljava/lang/reflect/Field;Ljava/lang/Object;)Z");
                            break;
                        }
                        case "setByte": {
                            ReflectFieldTransformer.replaceInstruction(instructions, methodInsnNode, "setByteField", "(Ljava/lang/reflect/Field;Ljava/lang/Object;B)V");
                            break;
                        }
                        case "getByte": {
                            ReflectFieldTransformer.replaceInstruction(instructions, methodInsnNode, "getByteField", "(Ljava/lang/reflect/Field;Ljava/lang/Object;)B");
                            break;
                        }
                        case "setChar": {
                            ReflectFieldTransformer.replaceInstruction(instructions, methodInsnNode, "setCharField", "(Ljava/lang/reflect/Field;Ljava/lang/Object;C)V");
                            break;
                        }
                        case "getChar": {
                            ReflectFieldTransformer.replaceInstruction(instructions, methodInsnNode, "getCharField", "(Ljava/lang/reflect/Field;Ljava/lang/Object;)C");
                            break;
                        }
                        case "setShort": {
                            ReflectFieldTransformer.replaceInstruction(instructions, methodInsnNode, "setShortField", "(Ljava/lang/reflect/Field;Ljava/lang/Object;S)V");
                            break;
                        }
                        case "getShort": {
                            ReflectFieldTransformer.replaceInstruction(instructions, methodInsnNode, "getShortField", "(Ljava/lang/reflect/Field;Ljava/lang/Object;)S");
                            break;
                        }
                        case "setInt": {
                            ReflectFieldTransformer.replaceInstruction(instructions, methodInsnNode, "setIntField", "(Ljava/lang/reflect/Field;Ljava/lang/Object;I)V");
                            break;
                        }
                        case "getInt": {
                            ReflectFieldTransformer.replaceInstruction(instructions, methodInsnNode, "getIntField", "(Ljava/lang/reflect/Field;Ljava/lang/Object;)I");
                            break;
                        }
                        case "setLong": {
                            ReflectFieldTransformer.replaceInstruction(instructions, methodInsnNode, "setLongField", "(Ljava/lang/reflect/Field;Ljava/lang/Object;J)V");
                            break;
                        }
                        case "getLong": {
                            ReflectFieldTransformer.replaceInstruction(instructions, methodInsnNode, "getLongField", "(Ljava/lang/reflect/Field;Ljava/lang/Object;)J");
                            break;
                        }
                        case "setFloat": {
                            ReflectFieldTransformer.replaceInstruction(instructions, methodInsnNode, "setFloatField", "(Ljava/lang/reflect/Field;Ljava/lang/Object;F)V");
                            break;
                        }
                        case "getFloat": {
                            ReflectFieldTransformer.replaceInstruction(instructions, methodInsnNode, "getFloatField", "(Ljava/lang/reflect/Field;Ljava/lang/Object;)F");
                            break;
                        }
                        case "setDouble": {
                            ReflectFieldTransformer.replaceInstruction(instructions, methodInsnNode, "setDoubleField", "(Ljava/lang/reflect/Field;Ljava/lang/Object;D)V");
                            break;
                        }
                        case "getDouble": {
                            ReflectFieldTransformer.replaceInstruction(instructions, methodInsnNode, "getDoubleField", "(Ljava/lang/reflect/Field;Ljava/lang/Object;)D");
                        }
                    }
                }
            }
        }
        ClassWriter classWriter = new ClassWriter(0);
        classNode.accept((ClassVisitor)classWriter);
        return classWriter.toByteArray();
    }
}

