/*
 * Decompiled with CFR 0.152.
 */
package com.cleanroommc.fugue.transformer.universal;

import net.minecraftforge.fml.common.FMLLog;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.commons.ClassRemapper;
import org.objectweb.asm.commons.Remapper;
import top.outlands.foundation.IExplicitTransformer;

public class RemapTransformer
implements IExplicitTransformer {
    private final String[] fromPrefixes;
    private final String[] toPrefixes;

    public RemapTransformer(String[] fromPrefixes, String[] toPrefixes) {
        this.fromPrefixes = fromPrefixes;
        this.toPrefixes = toPrefixes;
    }

    public byte[] transform(byte[] bytes) {
        if (bytes == null) {
            return null;
        }
        ClassReader reader = new ClassReader(bytes);
        ClassWriter writer = new ClassWriter(0);
        ClassRemapper visitor = new ClassRemapper((ClassVisitor)writer, (Remapper)new PrefixRemapper(this.fromPrefixes, this.toPrefixes));
        try {
            reader.accept((ClassVisitor)visitor, 8);
        }
        catch (Exception e) {
            FMLLog.log.warn("Couldn't remap class {}", (Object)reader.getClassName(), (Object)e);
            return bytes;
        }
        return writer.toByteArray();
    }

    static class PrefixRemapper
    extends Remapper {
        private final String[] fromPrefixes;
        private final String[] toPrefixes;

        public PrefixRemapper(String[] fromPrefixes, String[] toPrefixes) {
            this.fromPrefixes = fromPrefixes;
            this.toPrefixes = toPrefixes;
        }

        public String map(String typeName) {
            if (typeName == null) {
                return null;
            }
            for (int pfx = 0; pfx < this.fromPrefixes.length; ++pfx) {
                if (!typeName.startsWith(this.fromPrefixes[pfx])) continue;
                return this.toPrefixes[pfx] + typeName.substring(this.fromPrefixes[pfx].length());
            }
            return typeName;
        }
    }
}

