/*
 * Decompiled with CFR 0.152.
 */
package eu.decentsoftware.holograms.api;

import eu.decentsoftware.holograms.api.holograms.Hologram;
import eu.decentsoftware.holograms.api.holograms.HologramLine;
import eu.decentsoftware.holograms.api.holograms.HologramPage;
import eu.decentsoftware.holograms.api.holograms.enums.HologramLineType;
import eu.decentsoftware.holograms.api.utils.items.HologramItem;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import lombok.Generated;
import org.apache.commons.lang.Validate;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;

public final class DHAPI {
    public static Hologram createHologram(String name, Location location) throws IllegalArgumentException {
        return DHAPI.createHologram(name, location, false);
    }

    public static Hologram createHologram(String name, Location location, boolean saveToFile) throws IllegalArgumentException {
        return DHAPI.createHologram(name, location, saveToFile, new ArrayList<String>());
    }

    public static Hologram createHologram(String name, Location location, List<String> lines) throws IllegalArgumentException {
        return DHAPI.createHologram(name, location, false, lines);
    }

    public static Hologram createHologram(String name, Location location, boolean saveToFile, List<String> lines) throws IllegalArgumentException {
        Validate.notNull((Object)name);
        Validate.notNull((Object)location);
        if (!name.matches("[a-zA-Z0-9_-]+")) {
            throw new IllegalArgumentException(String.format("Hologram name can only contain alphanumeric characters, underscores and dashes! (%s)", name));
        }
        if (Hologram.getCachedHologramNames().contains(name)) {
            throw new IllegalArgumentException(String.format("Hologram with that name already exists! (%s)", name));
        }
        Hologram hologram = new Hologram(name, location, saveToFile);
        HologramPage page = hologram.getPage(0);
        if (lines != null) {
            for (String line : lines) {
                HologramLine hologramLine = new HologramLine(page, page.getNextLineLocation(), line);
                page.addLine(hologramLine);
            }
        }
        hologram.showAll();
        hologram.save();
        return hologram;
    }

    public static void moveHologram(String name, Location location) throws IllegalArgumentException {
        Validate.notNull((Object)name);
        Validate.notNull((Object)location);
        Hologram hologram = DHAPI.getHologram(name);
        if (hologram != null) {
            DHAPI.moveHologram(hologram, location);
        }
    }

    public static void moveHologram(Hologram hologram, Location location) throws IllegalArgumentException {
        Validate.notNull((Object)hologram);
        Validate.notNull((Object)location);
        Location hologramLocation = hologram.getLocation();
        hologramLocation.setWorld(location.getWorld());
        hologramLocation.setX(location.getX());
        hologramLocation.setY(location.getY());
        hologramLocation.setZ(location.getZ());
        hologram.setLocation(hologramLocation);
        hologram.realignLines();
        hologram.save();
    }

    public static void updateHologram(String name) {
        Validate.notNull((Object)name);
        Hologram hologram = DHAPI.getHologram(name);
        if (hologram != null) {
            hologram.updateAll(true);
        }
    }

    public static void removeHologram(String name) {
        Validate.notNull((Object)name);
        Hologram hologram = DHAPI.getHologram(name);
        if (hologram != null) {
            hologram.delete();
        }
    }

    public static HologramLine createHologramLine(HologramPage parent, String content) throws IllegalArgumentException {
        Validate.notNull((Object)parent);
        Validate.notNull((Object)content);
        return new HologramLine(parent, parent.getNextLineLocation(), content);
    }

    public static HologramLine createHologramLine(HologramPage parent, Location location, String content) throws IllegalArgumentException {
        Validate.notNull((Object)parent);
        Validate.notNull((Object)location);
        Validate.notNull((Object)content);
        return new HologramLine(parent, location, content);
    }

    public static HologramPage addHologramPage(Hologram hologram) throws IllegalArgumentException {
        return DHAPI.addHologramPage(hologram, null);
    }

    public static HologramPage addHologramPage(Hologram hologram, List<String> lines) throws IllegalArgumentException {
        Validate.notNull((Object)hologram);
        HologramPage page = hologram.addPage();
        if (lines != null && !lines.isEmpty()) {
            for (String content : lines) {
                HologramLine line = new HologramLine(page, page.getNextLineLocation(), content);
                page.addLine(line);
            }
        }
        hologram.save();
        return page;
    }

    public static HologramPage insertHologramPage(Hologram hologram, int index) throws IllegalArgumentException {
        return DHAPI.insertHologramPage(hologram, index, null);
    }

    public static HologramPage insertHologramPage(Hologram hologram, int index, List<String> lines) throws IllegalArgumentException {
        Validate.notNull((Object)hologram);
        HologramPage page = hologram.insertPage(index);
        if (page == null) {
            throw new IllegalArgumentException("Given page index is out of bounds for the hologram.");
        }
        if (lines != null && !lines.isEmpty()) {
            for (String content : lines) {
                HologramLine line = new HologramLine(page, page.getNextLineLocation(), content);
                page.addLine(line);
            }
        }
        hologram.save();
        return page;
    }

    @Nullable
    public static HologramPage removeHologramPage(Hologram hologram, int index) throws IllegalArgumentException {
        Validate.notNull((Object)hologram);
        HologramPage page = hologram.removePage(index);
        hologram.save();
        return page;
    }

    @Nullable
    public static Hologram getHologram(String name) throws IllegalArgumentException {
        Validate.notNull((Object)name);
        return Hologram.getCachedHologram(name);
    }

    @Nullable
    public static HologramPage getHologramPage(Hologram hologram, int index) throws IllegalArgumentException {
        Validate.notNull((Object)hologram);
        return hologram.getPage(index);
    }

    @Nullable
    public static HologramLine getHologramLine(HologramPage page, int index) throws IllegalArgumentException {
        Validate.notNull((Object)page);
        return page.getLine(index);
    }

    public static HologramLine addHologramLine(Hologram hologram, Material material) throws IllegalArgumentException {
        Validate.notNull((Object)material);
        return DHAPI.addHologramLine(hologram, new ItemStack(material));
    }

    public static HologramLine addHologramLine(Hologram hologram, ItemStack item) throws IllegalArgumentException {
        Validate.notNull((Object)item);
        return DHAPI.addHologramLine(hologram, "#ICON:" + HologramItem.fromItemStack(item).getContent());
    }

    public static HologramLine addHologramLine(Hologram hologram, String content) throws IllegalArgumentException {
        return DHAPI.addHologramLine(hologram, 0, content);
    }

    public static HologramLine addHologramLine(Hologram hologram, int pageIndex, String content) throws IllegalArgumentException {
        Validate.notNull((Object)hologram);
        Validate.notNull((Object)content);
        HologramPage page = hologram.getPage(pageIndex);
        if (page == null) {
            throw new IllegalArgumentException("Given page index is out of bounds for the hologram.");
        }
        return DHAPI.addHologramLine(page, content);
    }

    public static HologramLine addHologramLine(HologramPage page, Material material) throws IllegalArgumentException {
        Validate.notNull((Object)material);
        return DHAPI.addHologramLine(page, new ItemStack(material));
    }

    public static HologramLine addHologramLine(HologramPage page, ItemStack item) throws IllegalArgumentException {
        Validate.notNull((Object)item);
        return DHAPI.addHologramLine(page, "#ICON:" + HologramItem.fromItemStack(item).getContent());
    }

    public static HologramLine addHologramLine(HologramPage page, String content) throws IllegalArgumentException {
        HologramLine line = new HologramLine(page, page.getNextLineLocation(), content);
        page.addLine(line);
        page.getParent().save();
        return line;
    }

    public static HologramLine insertHologramLine(Hologram hologram, int lineIndex, Material material) throws IllegalArgumentException {
        Validate.notNull((Object)material);
        return DHAPI.insertHologramLine(hologram, lineIndex, new ItemStack(material));
    }

    public static HologramLine insertHologramLine(Hologram hologram, int lineIndex, ItemStack item) throws IllegalArgumentException {
        Validate.notNull((Object)item);
        return DHAPI.insertHologramLine(hologram, 0, lineIndex, item);
    }

    public static HologramLine insertHologramLine(Hologram hologram, int lineIndex, String content) throws IllegalArgumentException {
        return DHAPI.insertHologramLine(hologram, 0, lineIndex, content);
    }

    public static HologramLine insertHologramLine(Hologram hologram, int pageIndex, int lineIndex, Material material) throws IllegalArgumentException {
        Validate.notNull((Object)material);
        return DHAPI.insertHologramLine(hologram, pageIndex, lineIndex, new ItemStack(material));
    }

    public static HologramLine insertHologramLine(Hologram hologram, int pageIndex, int lineIndex, ItemStack item) throws IllegalArgumentException {
        Validate.notNull((Object)item);
        return DHAPI.insertHologramLine(hologram, pageIndex, lineIndex, "#ICON:" + HologramItem.fromItemStack(item).getContent());
    }

    public static HologramLine insertHologramLine(Hologram hologram, int pageIndex, int lineIndex, String content) throws IllegalArgumentException {
        Validate.notNull((Object)hologram);
        HologramPage page = hologram.getPage(pageIndex);
        if (page == null) {
            throw new IllegalArgumentException("Given page index is out of bounds for the hologram.");
        }
        return DHAPI.insertHologramLine(page, lineIndex, content);
    }

    public static HologramLine insertHologramLine(HologramPage page, int index, Material material) throws IllegalArgumentException {
        Validate.notNull((Object)material);
        return DHAPI.insertHologramLine(page, index, new ItemStack(material));
    }

    public static HologramLine insertHologramLine(HologramPage page, int index, ItemStack item) throws IllegalArgumentException {
        Validate.notNull((Object)item);
        return DHAPI.insertHologramLine(page, index, "#ICON:" + HologramItem.fromItemStack(item).getContent());
    }

    public static HologramLine insertHologramLine(HologramPage page, int index, String content) throws IllegalArgumentException {
        HologramLine oldLine = page.getLine(index);
        if (oldLine == null) {
            throw new IllegalArgumentException("Given line index is out of bounds for the hologram page.");
        }
        HologramLine line = new HologramLine(page, oldLine.getLocation().clone(), content);
        page.insertLine(index, line);
        page.getParent().save();
        return line;
    }

    public static void setHologramLine(HologramLine line, Material material) throws IllegalArgumentException {
        Validate.notNull((Object)material);
        DHAPI.setHologramLine(line, new ItemStack(material));
    }

    public static void setHologramLine(HologramLine line, ItemStack item) throws IllegalArgumentException {
        Validate.notNull((Object)item);
        DHAPI.setHologramLine(line, "#ICON:" + HologramItem.fromItemStack(item).getContent());
    }

    public static void setHologramLine(HologramLine line, String content) throws IllegalArgumentException {
        Validate.notNull((Object)line);
        Validate.notNull((Object)content);
        if (line.getContent().equals(content)) {
            return;
        }
        HologramLineType prevType = line.getType();
        HologramPage parent = line.getParent();
        line.setContent(content);
        if (prevType != line.getType()) {
            Player[] viewers = line.getViewerPlayers().toArray(new Player[0]);
            line.hide(new Player[0]);
            line.setContent(content);
            line.show(viewers);
            if (parent != null) {
                parent.realignLines();
            }
        }
        if (parent != null) {
            parent.getParent().save();
        }
    }

    public static void setHologramLine(HologramPage page, int lineIndex, Material material) throws IllegalArgumentException {
        Validate.notNull((Object)material);
        DHAPI.setHologramLine(page, lineIndex, new ItemStack(material));
    }

    public static void setHologramLine(HologramPage page, int lineIndex, ItemStack item) throws IllegalArgumentException {
        Validate.notNull((Object)item);
        DHAPI.setHologramLine(page, lineIndex, "#ICON:" + HologramItem.fromItemStack(item).getContent());
    }

    public static void setHologramLine(HologramPage page, int lineIndex, String content) throws IllegalArgumentException {
        Validate.notNull((Object)page);
        Validate.notNull((Object)content);
        HologramLine line = page.getLine(lineIndex);
        if (line == null) {
            throw new IllegalArgumentException("Given line index is out of bounds for the hologram page.");
        }
        DHAPI.setHologramLine(line, content);
    }

    public static void setHologramLine(Hologram hologram, int lineIndex, Material material) throws IllegalArgumentException {
        Validate.notNull((Object)material);
        DHAPI.setHologramLine(hologram, lineIndex, new ItemStack(material));
    }

    public static void setHologramLine(Hologram hologram, int lineIndex, ItemStack item) throws IllegalArgumentException {
        Validate.notNull((Object)item);
        DHAPI.setHologramLine(hologram, lineIndex, "#ICON:" + HologramItem.fromItemStack(item).getContent());
    }

    public static void setHologramLine(Hologram hologram, int lineIndex, String content) throws IllegalArgumentException {
        DHAPI.setHologramLine(hologram, 0, lineIndex, content);
    }

    public static void setHologramLine(Hologram hologram, int pageIndex, int lineIndex, Material material) throws IllegalArgumentException {
        Validate.notNull((Object)material);
        DHAPI.setHologramLine(hologram, pageIndex, lineIndex, new ItemStack(material));
    }

    public static void setHologramLine(Hologram hologram, int pageIndex, int lineIndex, ItemStack item) throws IllegalArgumentException {
        Validate.notNull((Object)item);
        DHAPI.setHologramLine(hologram, pageIndex, lineIndex, "#ICON:" + HologramItem.fromItemStack(item).getContent());
    }

    public static void setHologramLine(Hologram hologram, int pageIndex, int lineIndex, String content) throws IllegalArgumentException {
        Validate.notNull((Object)hologram);
        Validate.notNull((Object)content);
        HologramPage page = hologram.getPage(pageIndex);
        if (page == null) {
            throw new IllegalArgumentException("Given page index is out of bounds for the hologram.");
        }
        HologramLine line = page.getLine(lineIndex);
        if (line == null) {
            throw new IllegalArgumentException("Given line index is out of bounds for the hologram page.");
        }
        DHAPI.setHologramLine(line, content);
    }

    @Nullable
    public static HologramLine removeHologramLine(Hologram hologram, int lineIndex) throws IllegalArgumentException {
        return DHAPI.removeHologramLine(hologram, 0, lineIndex);
    }

    @Nullable
    public static HologramLine removeHologramLine(Hologram hologram, int pageIndex, int lineIndex) throws IllegalArgumentException {
        Validate.notNull((Object)hologram);
        HologramPage page = hologram.getPage(pageIndex);
        if (page == null) {
            throw new IllegalArgumentException("Given page index is out of bounds for the hologram.");
        }
        HologramLine line = page.removeLine(lineIndex);
        hologram.save();
        return line;
    }

    @Nullable
    public static HologramLine removeHologramLine(HologramPage page, int lineIndex) throws IllegalArgumentException {
        Validate.notNull((Object)page);
        HologramLine line = page.removeLine(lineIndex);
        page.getParent().save();
        return line;
    }

    public static void setHologramLines(Hologram hologram, List<String> lines) throws IllegalArgumentException {
        DHAPI.setHologramLines(hologram, 0, lines);
    }

    public static void setHologramLines(Hologram hologram, int pageIndex, List<String> lines) throws IllegalArgumentException {
        Validate.notNull((Object)hologram);
        Validate.notNull(lines);
        HologramPage page = hologram.getPage(pageIndex);
        if (page == null) {
            throw new IllegalArgumentException("Given page index is out of bounds for the hologram.");
        }
        while (page.size() > lines.size()) {
            page.removeLine(page.size() - 1);
        }
        for (int i = 0; i < lines.size(); ++i) {
            String content = lines.get(i);
            if (page.size() > i) {
                DHAPI.setHologramLine(page, i, content);
                continue;
            }
            HologramLine line = new HologramLine(page, page.getNextLineLocation(), content);
            page.addLine(line);
        }
        hologram.realignLines();
        hologram.updateAll(true);
        hologram.save();
    }

    @Generated
    private DHAPI() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

