/*
 * Decompiled with CFR 0.152.
 */
package eu.decentsoftware.holograms.api;

import eu.decentsoftware.holograms.api.Lang;
import eu.decentsoftware.holograms.api.Settings;
import eu.decentsoftware.holograms.api.animations.AnimationManager;
import eu.decentsoftware.holograms.api.commands.CommandManager;
import eu.decentsoftware.holograms.api.features.FeatureManager;
import eu.decentsoftware.holograms.api.holograms.Hologram;
import eu.decentsoftware.holograms.api.holograms.HologramManager;
import eu.decentsoftware.holograms.api.listeners.PlayerListener;
import eu.decentsoftware.holograms.api.listeners.WorldListener;
import eu.decentsoftware.holograms.api.utils.BungeeUtils;
import eu.decentsoftware.holograms.api.utils.Common;
import eu.decentsoftware.holograms.api.utils.Log;
import eu.decentsoftware.holograms.api.utils.UpdateChecker;
import eu.decentsoftware.holograms.api.utils.event.EventFactory;
import eu.decentsoftware.holograms.api.utils.reflect.Version;
import eu.decentsoftware.holograms.api.utils.tick.Ticker;
import eu.decentsoftware.holograms.integration.IntegrationAvailabilityService;
import eu.decentsoftware.holograms.metrics.bukkit.Metrics;
import eu.decentsoftware.holograms.metrics.charts.SingleLineChart;
import eu.decentsoftware.holograms.nms.DecentHologramsNmsPacketListener;
import eu.decentsoftware.holograms.nms.NmsAdapterFactory;
import eu.decentsoftware.holograms.nms.NmsPacketListenerService;
import eu.decentsoftware.holograms.nms.api.DecentHologramsNmsException;
import eu.decentsoftware.holograms.nms.api.NmsAdapter;
import java.io.File;
import java.util.logging.Logger;
import lombok.Generated;
import lombok.NonNull;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandSender;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.PluginManager;
import org.bukkit.plugin.java.JavaPlugin;
import org.jetbrains.annotations.Contract;

public final class DecentHolograms {
    private final JavaPlugin plugin;
    private NmsAdapter nmsAdapter;
    private IntegrationAvailabilityService integrationAvailabilityService;
    private NmsPacketListenerService nmsPacketListenerService;
    private HologramManager hologramManager;
    private CommandManager commandManager;
    private FeatureManager featureManager;
    private AnimationManager animationManager;
    private Ticker ticker;
    private boolean updateAvailable;

    DecentHolograms(@NonNull JavaPlugin plugin) {
        if (plugin == null) {
            throw new NullPointerException("plugin is marked non-null but is null");
        }
        this.plugin = plugin;
    }

    void enable() {
        Log.setLogger(this.plugin.getLogger());
        this.initializeNmsAdapter();
        Settings.reload();
        Lang.reload();
        PluginManager pluginManager = Bukkit.getPluginManager();
        this.integrationAvailabilityService = new IntegrationAvailabilityService(this.plugin, pluginManager);
        this.integrationAvailabilityService.initialize();
        this.ticker = new Ticker();
        this.hologramManager = new HologramManager(this);
        this.commandManager = new CommandManager();
        this.featureManager = new FeatureManager();
        this.animationManager = new AnimationManager(this);
        DecentHologramsNmsPacketListener nmsPacketListener = new DecentHologramsNmsPacketListener(this.hologramManager);
        this.nmsPacketListenerService = new NmsPacketListenerService(this.plugin, this.nmsAdapter, nmsPacketListener);
        pluginManager.registerEvents((Listener)new PlayerListener(this), (Plugin)this.plugin);
        pluginManager.registerEvents((Listener)new WorldListener(this.hologramManager), (Plugin)this.plugin);
        this.setupMetrics();
        this.checkForUpdates();
        BungeeUtils.init();
    }

    void disable() {
        this.nmsPacketListenerService.shutdown();
        this.featureManager.destroy();
        this.hologramManager.destroy();
        this.animationManager.destroy();
        this.ticker.destroy();
        for (Hologram hologram : Hologram.getCachedHolograms()) {
            hologram.destroy();
        }
        this.integrationAvailabilityService.shutdown();
        BungeeUtils.destroy();
    }

    public void reload() {
        Settings.reload();
        Lang.reload();
        this.animationManager.reload();
        this.hologramManager.reload();
        this.featureManager.reload();
        EventFactory.fireReloadEvent();
    }

    private void initializeNmsAdapter() {
        try {
            this.nmsAdapter = new NmsAdapterFactory().createNmsAdapter(Version.CURRENT);
            Log.info("Initialized NMS adapter for %s (%s).", Version.CURRENT.name(), Version.CURRENT_MINECRAFT_VERSION);
            return;
        }
        catch (DecentHologramsNmsException e) {
            Log.error("Error loading an NMS adapter for " + (Object)((Object)Version.CURRENT) + ": " + e.getMessage(), e);
        }
        catch (Exception e) {
            Log.error("Unknown error loading an NMS adapter for " + (Object)((Object)Version.CURRENT), e);
        }
        Log.error("The plugin will now be disabled.");
        Bukkit.getPluginManager().disablePlugin((Plugin)this.plugin);
    }

    private void setupMetrics() {
        Metrics metrics = new Metrics((Plugin)this.plugin, 12797);
        metrics.addCustomChart(new SingleLineChart("holograms", () -> Hologram.getCachedHolograms().size()));
    }

    private void checkForUpdates() {
        if (!Settings.CHECK_FOR_UPDATES) {
            return;
        }
        UpdateChecker updateChecker = new UpdateChecker(this.getPlugin(), 96927);
        updateChecker.getVersion(ver -> {
            String currentVersion = this.getPlugin().getDescription().getVersion();
            if (Common.isVersionHigher(currentVersion, ver)) {
                Lang.sendUpdateMessage((CommandSender)Bukkit.getConsoleSender());
                this.updateAvailable = true;
            }
        });
    }

    @Contract(pure=true)
    public File getDataFolder() {
        return this.plugin.getDataFolder();
    }

    @Contract(pure=true)
    public Logger getLogger() {
        return this.plugin.getLogger();
    }

    @Generated
    public JavaPlugin getPlugin() {
        return this.plugin;
    }

    @Generated
    public NmsAdapter getNmsAdapter() {
        return this.nmsAdapter;
    }

    @Generated
    public IntegrationAvailabilityService getIntegrationAvailabilityService() {
        return this.integrationAvailabilityService;
    }

    @Generated
    public NmsPacketListenerService getNmsPacketListenerService() {
        return this.nmsPacketListenerService;
    }

    @Generated
    public HologramManager getHologramManager() {
        return this.hologramManager;
    }

    @Generated
    public CommandManager getCommandManager() {
        return this.commandManager;
    }

    @Generated
    public FeatureManager getFeatureManager() {
        return this.featureManager;
    }

    @Generated
    public AnimationManager getAnimationManager() {
        return this.animationManager;
    }

    @Generated
    public Ticker getTicker() {
        return this.ticker;
    }

    @Generated
    public boolean isUpdateAvailable() {
        return this.updateAvailable;
    }
}

