/*
 * Decompiled with CFR 0.152.
 */
package eu.decentsoftware.holograms.api.animations.custom;

import eu.decentsoftware.holograms.api.DecentHolograms;
import eu.decentsoftware.holograms.api.DecentHologramsAPI;
import eu.decentsoftware.holograms.api.animations.TextAnimation;
import eu.decentsoftware.holograms.api.utils.config.FileConfig;
import java.util.ArrayList;
import java.util.List;
import lombok.NonNull;

public class CustomTextAnimation
extends TextAnimation {
    private static final DecentHolograms DECENT_HOLOGRAMS = DecentHologramsAPI.get();
    private final List<String> steps;

    public CustomTextAnimation(@NonNull String name, int speed, int pause, @NonNull List<String> steps) {
        super(name, speed, pause);
        if (name == null) {
            throw new NullPointerException("name is marked non-null but is null");
        }
        if (steps == null) {
            throw new NullPointerException("steps is marked non-null but is null");
        }
        this.steps = steps;
    }

    public CustomTextAnimation(@NonNull String name, int speed, int pause, @NonNull List<String> steps, String ... aliases) {
        super(name, speed, pause, aliases);
        if (name == null) {
            throw new NullPointerException("name is marked non-null but is null");
        }
        if (steps == null) {
            throw new NullPointerException("steps is marked non-null but is null");
        }
        this.steps = steps;
    }

    @Override
    public String animate(@NonNull String string, long step, String ... args) {
        if (string == null) {
            throw new NullPointerException("string is marked non-null but is null");
        }
        int currentStepIndex = this.getCurrentStep(step, this.steps.size() - 1);
        String currentStep = this.steps.get(currentStepIndex);
        currentStep = currentStep.replace("{text}", string);
        return currentStep;
    }

    public static CustomTextAnimation fromFile(@NonNull String fileName) {
        if (fileName == null) {
            throw new NullPointerException("fileName is marked non-null but is null");
        }
        FileConfig config = new FileConfig(DECENT_HOLOGRAMS.getPlugin(), "animations/" + fileName);
        String name = fileName.toLowerCase().startsWith("animation_") && fileName.length() > "animation_".length() ? fileName.substring("animation_".length(), fileName.length() - 4) : fileName.substring(0, fileName.length() - 4);
        int speed = config.isInt("speed") ? config.getInt("speed") : 1;
        int pause = config.isInt("pause") ? config.getInt("pause") : 1;
        ArrayList<String> steps = config.isList("steps") ? config.getStringList("steps") : new ArrayList();
        return new CustomTextAnimation(name, speed, pause, steps);
    }
}

