/*
 * Decompiled with CFR 0.152.
 */
package eu.decentsoftware.holograms.api.animations.text;

import eu.decentsoftware.holograms.api.animations.TextAnimation;
import eu.decentsoftware.holograms.api.utils.Common;
import eu.decentsoftware.holograms.api.utils.color.IridiumColorAPI;
import java.util.Arrays;
import lombok.NonNull;

public class TypewriterAnimation
extends TextAnimation {
    public TypewriterAnimation() {
        super("typewriter", 3, 20);
    }

    @Override
    public String animate(@NonNull String string, long step, String ... args) {
        if (string == null) {
            throw new NullPointerException("string is marked non-null but is null");
        }
        StringBuilder specialColors = new StringBuilder();
        for (String color : IridiumColorAPI.SPECIAL_COLORS) {
            if (!string.contains(color)) continue;
            specialColors.append(color);
            string = string.replace(color, "");
        }
        String stripped = Common.stripColors(string);
        int currentStep = this.getCurrentStep(step, stripped.length());
        return specialColors + String.valueOf(Arrays.copyOfRange(stripped.toCharArray(), 0, currentStep));
    }
}

