/*
 * Decompiled with CFR 0.152.
 */
package eu.decentsoftware.holograms.api.animations.text;

import eu.decentsoftware.holograms.api.animations.TextAnimation;
import eu.decentsoftware.holograms.api.utils.Common;
import eu.decentsoftware.holograms.api.utils.color.IridiumColorAPI;
import lombok.NonNull;

public class WaveAnimation
extends TextAnimation {
    public WaveAnimation() {
        super("wave", 2, 40);
    }

    @Override
    public String animate(@NonNull String string, long step, String ... args) {
        int size;
        if (string == null) {
            throw new NullPointerException("string is marked non-null but is null");
        }
        StringBuilder specialColors = new StringBuilder();
        for (String color : IridiumColorAPI.SPECIAL_COLORS) {
            if (!string.contains(color)) continue;
            specialColors.append(color);
            string = string.replace(color, "");
        }
        String stripped = Common.stripColors(string);
        int length = stripped.length();
        int currentStep = this.getCurrentStep(step, length + (size = length / 4));
        int index1 = currentStep > size ? currentStep - size : 0;
        int index2 = currentStep < size ? size - (size - currentStep) : currentStep;
        String colPrimary = args[0];
        String colSecondary = args.length == 1 ? "&f" : args[1];
        String start = index1 != 0 ? stripped.substring(0, index1) : "";
        String mid = length > index2 ? stripped.substring(index1, index2) : stripped.substring(index1);
        String end = length > index2 ? stripped.substring(index2) : "";
        return colPrimary + specialColors + start + colSecondary + specialColors + mid + colPrimary + specialColors + end;
    }
}

