/*
 * Decompiled with CFR 0.152.
 */
package eu.decentsoftware.holograms.api.holograms;

import com.google.common.util.concurrent.AtomicDouble;
import eu.decentsoftware.holograms.api.DecentHolograms;
import eu.decentsoftware.holograms.api.DecentHologramsAPI;
import eu.decentsoftware.holograms.api.Settings;
import eu.decentsoftware.holograms.api.holograms.HologramPage;
import eu.decentsoftware.holograms.api.holograms.enums.EnumFlag;
import eu.decentsoftware.holograms.api.holograms.enums.HologramLineType;
import eu.decentsoftware.holograms.api.holograms.objects.HologramObject;
import eu.decentsoftware.holograms.api.utils.Common;
import eu.decentsoftware.holograms.api.utils.Log;
import eu.decentsoftware.holograms.api.utils.PAPI;
import eu.decentsoftware.holograms.api.utils.entity.HologramEntity;
import eu.decentsoftware.holograms.api.utils.items.HologramItem;
import eu.decentsoftware.holograms.nms.api.NmsHologramPartData;
import eu.decentsoftware.holograms.nms.api.renderer.NmsEntityHologramRenderer;
import eu.decentsoftware.holograms.nms.api.renderer.NmsHeadHologramRenderer;
import eu.decentsoftware.holograms.nms.api.renderer.NmsHologramRenderer;
import eu.decentsoftware.holograms.nms.api.renderer.NmsIconHologramRenderer;
import eu.decentsoftware.holograms.nms.api.renderer.NmsSmallHeadHologramRenderer;
import eu.decentsoftware.holograms.nms.api.renderer.NmsTextHologramRenderer;
import eu.decentsoftware.holograms.shared.DecentPosition;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import lombok.Generated;
import lombok.NonNull;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class HologramLine
extends HologramObject {
    protected static final DecentHolograms DECENT_HOLOGRAMS = DecentHologramsAPI.get();
    private final HologramPage parent;
    private final Map<UUID, String> playerTextMap = new ConcurrentHashMap<UUID, String>();
    private final Map<UUID, String> lastTextMap = new ConcurrentHashMap<UUID, String>();
    private HologramLineType type;
    private final AtomicDouble offsetX = new AtomicDouble(0.0);
    private final AtomicDouble offsetY = new AtomicDouble(0.0);
    private final AtomicDouble offsetZ = new AtomicDouble(0.0);
    private double height;
    private String content;
    private String text;
    private HologramItem item;
    private HologramEntity entity;
    private NmsHologramRenderer<?> previousRenderer;
    private NmsHologramRenderer<?> renderer;
    private final Object renderMutex = new Object();
    private volatile boolean containsAnimations;
    private volatile boolean containsPlaceholders;

    @NonNull
    public static HologramLine fromFile(@NonNull ConfigurationSection config, @Nullable HologramPage parent, @NonNull Location location) {
        if (config == null) {
            throw new NullPointerException("config is marked non-null but is null");
        }
        if (location == null) {
            throw new NullPointerException("location is marked non-null but is null");
        }
        HologramLine line = new HologramLine(parent, location, config.getString("content", Settings.DEFAULT_TEXT));
        if (config.isString("permission")) {
            line.setPermission(config.getString("permission", null));
        }
        if (config.isList("flags")) {
            line.addFlags((EnumFlag[])config.getStringList("flags").stream().map(EnumFlag::valueOf).toArray(EnumFlag[]::new));
        }
        if (config.isDouble("height")) {
            line.setHeight(config.getDouble("height"));
        }
        if (config.isDouble("offsetX")) {
            line.setOffsetX(config.getDouble("offsetX"));
        }
        if (config.isDouble("offsetZ")) {
            line.setOffsetZ(config.getDouble("offsetZ"));
        }
        if (config.isDouble("facing")) {
            line.setFacing((float)config.getDouble("facing"));
        }
        return line;
    }

    @NonNull
    public static HologramLine fromMap(@NonNull Map<String, Object> map, @Nullable HologramPage parent, @NonNull Location location) {
        Object facing;
        Object offsetZ;
        Object offsetX;
        Object permission;
        Object flags;
        Object height;
        if (map == null) {
            throw new NullPointerException("map is marked non-null but is null");
        }
        if (location == null) {
            throw new NullPointerException("location is marked non-null but is null");
        }
        String content = (String)map.getOrDefault("content", Settings.DEFAULT_TEXT);
        HologramLine line = new HologramLine(parent, location, content);
        if (map.containsKey("height") && (height = map.get("height")) instanceof Double) {
            line.setHeight((Double)height);
        }
        if (map.containsKey("flags") && (flags = map.get("flags")) instanceof List) {
            try {
                line.addFlags((EnumFlag[])((List)flags).stream().map(EnumFlag::valueOf).toArray(EnumFlag[]::new));
            }
            catch (Exception e) {
                Log.warn("Flags for line %s seem to be invalid!", content);
            }
        }
        if (map.containsKey("permission") && (permission = map.get("permission")) instanceof String) {
            line.setPermission((String)permission);
        }
        if (map.containsKey("offsetX") && (offsetX = map.get("offsetX")) instanceof Double) {
            line.setOffsetX((Double)offsetX);
        }
        if (map.containsKey("offsetZ") && (offsetZ = map.get("offsetZ")) instanceof Double) {
            line.setOffsetZ((Double)offsetZ);
        }
        if (map.containsKey("facing") && (facing = map.get("facing")) instanceof Double) {
            line.setFacing(((Double)facing).floatValue());
        }
        return line;
    }

    public HologramLine(@Nullable HologramPage parent, @NonNull Location location, @NotNull String content) {
        super(location);
        if (location == null) {
            throw new NullPointerException("location is marked non-null but is null");
        }
        this.parent = parent;
        this.content = content;
        this.type = HologramLineType.UNKNOWN;
        this.height = Settings.DEFAULT_HEIGHT_TEXT;
        this.parseContent();
    }

    public String toString() {
        return "DefaultHologramLine{content=" + this.content + "} " + super.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setContent(@Nullable String content) {
        Object object = this.renderMutex;
        synchronized (object) {
            this.content = content == null ? "" : content;
            this.parseContent();
            this.update(true, new Player[0]);
        }
    }

    @Override
    public void enable() {
        super.enable();
        this.show(new Player[0]);
    }

    @Override
    public void disable() {
        super.disable();
        this.hide(new Player[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void parseContent() {
        Object object = this.renderMutex;
        synchronized (object) {
            HologramLineType prevType = this.type;
            String contentU = this.content.toUpperCase(Locale.ROOT);
            if (contentU.startsWith("#ICON:")) {
                this.type = HologramLineType.ICON;
                if (prevType != this.type) {
                    this.height = Settings.DEFAULT_HEIGHT_ICON;
                    this.previousRenderer = this.renderer;
                    this.renderer = DECENT_HOLOGRAMS.getNmsAdapter().getHologramComponentFactory().createIconRenderer();
                }
                this.item = new HologramItem(this.content.substring("#ICON:".length()));
                this.containsPlaceholders = PAPI.containsPlaceholders(this.item.getContent());
            } else if (contentU.startsWith("#SMALLHEAD:")) {
                this.type = HologramLineType.SMALLHEAD;
                if (prevType != this.type) {
                    this.height = Settings.DEFAULT_HEIGHT_SMALLHEAD;
                    this.previousRenderer = this.renderer;
                    this.renderer = DECENT_HOLOGRAMS.getNmsAdapter().getHologramComponentFactory().createSmallHeadRenderer();
                }
                this.item = new HologramItem(this.content.substring("#SMALLHEAD:".length()));
                this.containsPlaceholders = PAPI.containsPlaceholders(this.item.getContent());
            } else if (contentU.startsWith("#HEAD:")) {
                this.type = HologramLineType.HEAD;
                if (prevType != this.type) {
                    this.height = Settings.DEFAULT_HEIGHT_HEAD;
                    this.previousRenderer = this.renderer;
                    this.renderer = DECENT_HOLOGRAMS.getNmsAdapter().getHologramComponentFactory().createHeadRenderer();
                }
                this.item = new HologramItem(this.content.substring("#HEAD:".length()));
                this.containsPlaceholders = PAPI.containsPlaceholders(this.item.getContent());
            } else if (contentU.startsWith("#ENTITY:")) {
                this.type = HologramLineType.ENTITY;
                String entityContent = this.content.substring("#ENTITY:".length()).trim();
                this.entity = new HologramEntity(entityContent);
                if (prevType != this.type) {
                    this.previousRenderer = this.renderer;
                    this.renderer = DECENT_HOLOGRAMS.getNmsAdapter().getHologramComponentFactory().createEntityRenderer();
                }
                NmsHologramPartData<EntityType> data = new NmsHologramPartData<EntityType>(this.getPositionSupplier(), () -> this.entity.getType());
                this.height = ((NmsEntityHologramRenderer)this.renderer).getHeight(data);
                this.setOffsetY(-this.height);
            } else {
                this.type = HologramLineType.TEXT;
                if (prevType != this.type) {
                    this.height = Settings.DEFAULT_HEIGHT_TEXT;
                    this.previousRenderer = this.renderer;
                    this.renderer = DECENT_HOLOGRAMS.getNmsAdapter().getHologramComponentFactory().createTextRenderer();
                }
                this.text = this.parseCustomReplacements();
                this.containsAnimations = DECENT_HOLOGRAMS.getAnimationManager().containsAnimations(this.text);
                this.containsPlaceholders = PAPI.containsPlaceholders(this.text);
            }
        }
    }

    @NonNull
    public Map<String, Object> serializeToMap() {
        LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
        map.put("content", this.content);
        map.put("height", this.height);
        if (!this.flags.isEmpty()) {
            map.put("flags", this.flags.stream().map(Enum::name).collect(Collectors.toList()));
        }
        if (this.permission != null && !this.permission.trim().isEmpty()) {
            map.put("permission", this.permission);
        }
        if (this.getOffsetX() != 0.0) {
            map.put("offsetX", this.offsetX);
        }
        if (this.getOffsetZ() != 0.0) {
            map.put("offsetZ", this.offsetZ);
        }
        if (this.parent == null || this.getFacing() != this.parent.getParent().getFacing()) {
            map.put("facing", Float.valueOf(this.facing));
        }
        return map;
    }

    @NonNull
    public HologramLine clone(@Nullable HologramPage parent, @NonNull Location location) {
        if (location == null) {
            throw new NullPointerException("location is marked non-null but is null");
        }
        HologramLine line = new HologramLine(parent, location, this.getContent());
        line.setHeight(this.getHeight());
        line.setOffsetY(this.getOffsetY());
        line.setOffsetX(this.getOffsetX());
        line.setOffsetZ(this.getOffsetZ());
        line.setFacing(this.getFacing());
        line.setPermission(this.getPermission());
        line.addFlags(this.getFlags().toArray(new EnumFlag[0]));
        return line;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NonNull
    public HologramLineType getType() {
        Object object = this.renderMutex;
        synchronized (object) {
            return this.type != null ? this.type : HologramLineType.UNKNOWN;
        }
    }

    @NotNull
    private String getText(@NonNull Player player, boolean update) {
        if (player == null) {
            throw new NullPointerException("player is marked non-null but is null");
        }
        if (this.type != HologramLineType.TEXT) {
            return "";
        }
        UUID uuid = player.getUniqueId();
        String string = this.playerTextMap.get(uuid);
        if (update || string == null) {
            String string2 = string = this.text == null ? "" : this.text;
            if (!this.hasFlag(EnumFlag.DISABLE_PLACEHOLDERS)) {
                string = this.parsePlaceholders(string, player, this.containsPlaceholders);
            }
            this.playerTextMap.put(uuid, string);
        }
        if (this.containsAnimations && !this.hasFlag(EnumFlag.DISABLE_ANIMATIONS)) {
            string = DECENT_HOLOGRAMS.getAnimationManager().parseTextAnimations(string);
            if (Settings.ALLOW_PLACEHOLDERS_INSIDE_ANIMATIONS && !this.hasFlag(EnumFlag.DISABLE_PLACEHOLDERS)) {
                string = this.parsePlaceholders(string, player, true);
            }
        }
        return Common.colorize(string);
    }

    @NonNull
    private List<Player> getPlayers(boolean onlyViewers, Player ... players) {
        ArrayList<Player> playerList = players == null || players.length == 0 ? (onlyViewers ? this.getViewerPlayers() : new ArrayList<Player>(Bukkit.getOnlinePlayers())) : Arrays.asList(players);
        return playerList;
    }

    @NotNull
    private String parsePlaceholders(@NotNull String string, @NonNull Player player, boolean papi) {
        if (player == null) {
            throw new NullPointerException("player is marked non-null but is null");
        }
        string = string.replace("{player}", player.getName());
        string = string.replace("{page}", String.valueOf(this.parent != null ? this.parent.getIndex() + 1 : 1));
        string = string.replace("{pages}", String.valueOf(this.parent != null ? this.parent.getParent().size() : 1));
        if (papi && (string = PAPI.setPlaceholders(player, string)) == null) {
            string = "";
        }
        return string;
    }

    @NonNull
    private String parseCustomReplacements() {
        if (!this.content.isEmpty()) {
            for (Map.Entry<String, String> replacement : Settings.CUSTOM_REPLACEMENTS.entrySet()) {
                this.content = this.content.replace(replacement.getKey(), replacement.getValue());
            }
        }
        return this.content;
    }

    public boolean hasPermission(@NonNull Player player) {
        if (player == null) {
            throw new NullPointerException("player is marked non-null but is null");
        }
        return this.permission == null || this.permission.isEmpty() || player.hasPermission(this.permission);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateVisibility(@NonNull Player player) {
        if (player == null) {
            throw new NullPointerException("player is marked non-null but is null");
        }
        Object object = this.renderMutex;
        synchronized (object) {
            if (!(!this.isVisible(player) || this.hasPermission(player) && this.isInDisplayRange(player))) {
                this.hide(player);
            } else if (!this.isVisible(player) && this.hasPermission(player) && this.isInDisplayRange(player)) {
                this.show(player);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void show(Player ... players) {
        Object object = this.renderMutex;
        synchronized (object) {
            if (this.isDisabled()) {
                return;
            }
            this.hidePreviousIfNecessary();
            List<Player> playerList = this.getPlayers(false, players);
            for (Player player : playerList) {
                if (player == null || this.parent != null && this.parent.getParent().isHideState(player) || this.isVisible(player) || !this.canShow(player) || !this.isInDisplayRange(player)) continue;
                this.renderer.display(player, (NmsHologramPartData<?>)this.getPartData(player, true, false));
                this.viewers.add(player.getUniqueId());
            }
        }
    }

    public void update(Player ... players) {
        this.update(false, players);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void update(boolean force, Player ... players) {
        Object object = this.renderMutex;
        synchronized (object) {
            if (this.isDisabled() || this.hasFlag(EnumFlag.DISABLE_UPDATING)) {
                return;
            }
            this.hidePreviousIfNecessary();
            List<Player> playerList = this.getPlayers(true, players);
            for (Player player : playerList) {
                if (this.renderer instanceof NmsTextHologramRenderer) {
                    this.updateTextIfNecessary(player, true);
                    continue;
                }
                if (!this.containsPlaceholders && !force) continue;
                this.renderer.updateContent(player, (NmsHologramPartData<?>)this.getPartData(player, true, true));
            }
        }
    }

    private EntityType getEntityType(Player player) {
        String finalContent = PAPI.setPlaceholders(player, this.getEntity().getContent());
        HologramEntity hologramEntity = new HologramEntity(finalContent);
        return hologramEntity.getType();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateLocation(boolean updateRotation, Player ... players) {
        Object object = this.renderMutex;
        synchronized (object) {
            if (this.isDisabled()) {
                return;
            }
            this.hidePreviousIfNecessary();
            List<Player> playerList = this.getPlayers(true, players);
            for (Player player : playerList) {
                this.renderer.move(player, (NmsHologramPartData<?>)this.getPartData(player, false, true));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateAnimations(Player ... players) {
        Object object = this.renderMutex;
        synchronized (object) {
            if (this.isDisabled() || this.type != HologramLineType.TEXT || this.hasFlag(EnumFlag.DISABLE_ANIMATIONS)) {
                return;
            }
            this.hidePreviousIfNecessary();
            List<Player> playerList = this.getPlayers(true, players);
            for (Player player : playerList) {
                if (!(this.renderer instanceof NmsTextHologramRenderer)) continue;
                this.updateTextIfNecessary(player, false);
            }
        }
    }

    private void updateTextIfNecessary(Player player, boolean updatePlaceholders) {
        UUID uuid = player.getUniqueId();
        String lastText = this.lastTextMap.get(uuid);
        String updatedText = this.getText(player, updatePlaceholders);
        if (!updatedText.equals(lastText)) {
            this.lastTextMap.put(uuid, updatedText);
            NmsHologramPartData<String> partData = new NmsHologramPartData<String>(this.getPositionSupplier(), () -> updatedText);
            ((NmsTextHologramRenderer)this.renderer).updateContent(player, partData);
        }
    }

    private <T extends NmsHologramPartData<?>> T getPartData(Player player, boolean updateText, boolean cacheText) {
        Supplier<DecentPosition> positionSupplier = this.getPositionSupplier();
        if (this.renderer instanceof NmsTextHologramRenderer) {
            return (T)this.getTextPartData(player, updateText, cacheText, positionSupplier);
        }
        if (this.renderer instanceof NmsSmallHeadHologramRenderer || this.renderer instanceof NmsHeadHologramRenderer || this.renderer instanceof NmsIconHologramRenderer) {
            return (T)new NmsHologramPartData<ItemStack>(positionSupplier, () -> HologramItem.parseItemStack(this.item.getContent(), player));
        }
        if (this.renderer instanceof NmsEntityHologramRenderer) {
            return (T)new NmsHologramPartData<EntityType>(positionSupplier, () -> this.getEntityType(player));
        }
        throw new IllegalStateException("Unsupported renderer type: " + this.renderer.getClass().getName());
    }

    private Supplier<DecentPosition> getPositionSupplier() {
        return () -> DecentPosition.fromBukkitLocation(this.getLocation());
    }

    private NmsHologramPartData<String> getTextPartData(Player player, boolean updateText, boolean cacheText, Supplier<DecentPosition> positionSupplier) {
        if (!cacheText) {
            return new NmsHologramPartData<String>(positionSupplier, () -> this.getText(player, updateText));
        }
        return new NmsHologramPartData<String>(positionSupplier, () -> {
            UUID uuid = player.getUniqueId();
            String lastText = this.lastTextMap.get(uuid);
            String updatedText = this.getText(player, updateText);
            if (!updatedText.equals(lastText)) {
                this.lastTextMap.put(uuid, updatedText);
            }
            return updatedText;
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void hide(Player ... players) {
        Object object = this.renderMutex;
        synchronized (object) {
            this.hidePreviousIfNecessary();
            List<Player> playerList = this.getPlayers(true, players);
            for (Player player : playerList) {
                this.renderer.hide(player);
                this.viewers.remove(player.getUniqueId());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void hidePreviousIfNecessary() {
        Object object = this.renderMutex;
        synchronized (object) {
            if (this.previousRenderer == null) {
                return;
            }
            this.getViewerPlayers().forEach(this.previousRenderer::hide);
            this.previousRenderer = null;
        }
    }

    public boolean isInDisplayRange(@NonNull Player player) {
        if (player == null) {
            throw new NullPointerException("player is marked non-null but is null");
        }
        return this.parent == null || this.parent.getParent().isInDisplayRange(player);
    }

    public boolean isInUpdateRange(@NonNull Player player) {
        if (player == null) {
            throw new NullPointerException("player is marked non-null but is null");
        }
        return this.parent == null || this.parent.getParent().isInUpdateRange(player);
    }

    public double getOffsetX() {
        return this.offsetX.get();
    }

    public double getOffsetY() {
        return this.offsetY.get();
    }

    public double getOffsetZ() {
        return this.offsetZ.get();
    }

    public void setOffsetX(double offsetX) {
        this.offsetX.set(offsetX);
    }

    public void setOffsetY(double offsetY) {
        this.offsetY.set(offsetY);
    }

    public void setOffsetZ(double offsetZ) {
        this.offsetZ.set(offsetZ);
    }

    @Override
    public boolean hasFlag(@NonNull EnumFlag flag) {
        if (flag == null) {
            throw new NullPointerException("flag is marked non-null but is null");
        }
        return super.hasFlag(flag) || this.parent != null && this.parent.getParent().hasFlag(flag);
    }

    @Override
    public boolean canShow(@NonNull Player player) {
        if (player == null) {
            throw new NullPointerException("player is marked non-null but is null");
        }
        return super.canShow(player) && (this.parent == null || this.parent.getParent().canShow(player));
    }

    public int[] getEntityIds() {
        return this.renderer.getEntityIds();
    }

    @Generated
    public HologramPage getParent() {
        return this.parent;
    }

    @Generated
    public Map<UUID, String> getPlayerTextMap() {
        return this.playerTextMap;
    }

    @Generated
    public Map<UUID, String> getLastTextMap() {
        return this.lastTextMap;
    }

    @Generated
    public double getHeight() {
        return this.height;
    }

    @Generated
    public String getContent() {
        return this.content;
    }

    @Generated
    public String getText() {
        return this.text;
    }

    @Generated
    public HologramItem getItem() {
        return this.item;
    }

    @Generated
    public HologramEntity getEntity() {
        return this.entity;
    }

    @Generated
    public NmsHologramRenderer<?> getPreviousRenderer() {
        return this.previousRenderer;
    }

    @Generated
    public NmsHologramRenderer<?> getRenderer() {
        return this.renderer;
    }

    @Generated
    public Object getRenderMutex() {
        return this.renderMutex;
    }

    @Generated
    public boolean isContainsAnimations() {
        return this.containsAnimations;
    }

    @Generated
    public boolean isContainsPlaceholders() {
        return this.containsPlaceholders;
    }

    @Generated
    public void setType(HologramLineType type) {
        this.type = type;
    }

    @Generated
    public void setHeight(double height) {
        this.height = height;
    }

    @Generated
    public void setText(String text) {
        this.text = text;
    }

    @Generated
    public void setItem(HologramItem item) {
        this.item = item;
    }

    @Generated
    public void setEntity(HologramEntity entity) {
        this.entity = entity;
    }

    @Generated
    public void setPreviousRenderer(NmsHologramRenderer<?> previousRenderer) {
        this.previousRenderer = previousRenderer;
    }

    @Generated
    public void setRenderer(NmsHologramRenderer<?> renderer) {
        this.renderer = renderer;
    }

    @Generated
    public void setContainsAnimations(boolean containsAnimations) {
        this.containsAnimations = containsAnimations;
    }

    @Generated
    public void setContainsPlaceholders(boolean containsPlaceholders) {
        this.containsPlaceholders = containsPlaceholders;
    }
}

