/*
 * Decompiled with CFR 0.152.
 */
package eu.decentsoftware.holograms.api.holograms;

import com.google.common.collect.ImmutableList;
import eu.decentsoftware.holograms.api.DecentHologramsAPI;
import eu.decentsoftware.holograms.api.actions.Action;
import eu.decentsoftware.holograms.api.actions.ClickType;
import eu.decentsoftware.holograms.api.holograms.Hologram;
import eu.decentsoftware.holograms.api.holograms.HologramLine;
import eu.decentsoftware.holograms.api.holograms.enums.EnumFlag;
import eu.decentsoftware.holograms.api.holograms.enums.HologramLineType;
import eu.decentsoftware.holograms.api.holograms.objects.FlagHolder;
import eu.decentsoftware.holograms.nms.api.renderer.NmsClickableHologramRenderer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import lombok.Generated;
import lombok.NonNull;
import org.bukkit.Location;
import org.bukkit.entity.Player;

public class HologramPage
extends FlagHolder {
    private int index;
    private final Hologram parent;
    private final List<NmsClickableHologramRenderer> clickableEntityRenderers = new ArrayList<NmsClickableHologramRenderer>();
    private final List<HologramLine> lines = new ArrayList<HologramLine>();
    private final Map<ClickType, List<Action>> actions = new EnumMap<ClickType, List<Action>>(ClickType.class);

    public HologramPage(@NonNull Hologram parent, int index) {
        if (parent == null) {
            throw new NullPointerException("parent is marked non-null but is null");
        }
        this.parent = parent;
        this.index = index;
    }

    @NonNull
    public Hologram getParent() {
        return this.parent;
    }

    public double getHeight() {
        double height = 0.0;
        for (HologramLine hologramLine : this.lines) {
            height += hologramLine.getHeight();
        }
        return height;
    }

    @NonNull
    public Location getCenter() {
        Location center = this.parent.getLocation().clone();
        if (this.parent.isDownOrigin()) {
            center.add(0.0, this.getHeight() / 2.0, 0.0);
        } else {
            center.subtract(0.0, this.getHeight() / 2.0, 0.0);
        }
        return center;
    }

    public int size() {
        return this.lines.size();
    }

    @NonNull
    public Map<String, Object> serializeToMap() {
        LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
        ArrayList<Map<String, Object>> linesMap = new ArrayList<Map<String, Object>>();
        for (int i = 1; i <= this.lines.size(); ++i) {
            HologramLine line = this.lines.get(i - 1);
            linesMap.add(line.serializeToMap());
        }
        map.put("lines", linesMap);
        LinkedHashMap actionsMap = new LinkedHashMap();
        for (Map.Entry<ClickType, List<Action>> entry : this.getActions().entrySet()) {
            actionsMap.put(entry.getKey().name(), entry.getValue().stream().map(Action::toString).collect(Collectors.toList()));
        }
        map.put("actions", actionsMap);
        return map;
    }

    @NonNull
    public HologramPage clone(@NonNull Hologram parent, int index) {
        if (parent == null) {
            throw new NullPointerException("parent is marked non-null but is null");
        }
        HologramPage page = new HologramPage(parent, index);
        for (HologramLine hologramLine : this.getLines()) {
            page.addLine(hologramLine.clone(page, page.getNextLineLocation()));
        }
        for (Map.Entry entry : this.getActions().entrySet()) {
            for (Action action : (List)entry.getValue()) {
                page.addAction((ClickType)((Object)entry.getKey()), action);
            }
        }
        page.addFlags(this.getFlags().toArray(new EnumFlag[0]));
        return page;
    }

    public void realignLines() {
        Location currentLocation = this.parent.getLocation().clone();
        if (this.parent.isDownOrigin()) {
            currentLocation.add(0.0, this.getHeight(), 0.0);
        }
        for (HologramLine line : this.lines) {
            Location lineLocation = line.getLocation();
            lineLocation.setX(currentLocation.getX() + line.getOffsetX());
            lineLocation.setY(currentLocation.getY() + line.getOffsetY());
            lineLocation.setZ(currentLocation.getZ() + line.getOffsetZ());
            line.setLocation(lineLocation);
            line.updateLocation(true, new Player[0]);
            currentLocation.subtract(0.0, line.getHeight(), 0.0);
        }
    }

    public boolean addLine(@NonNull HologramLine line) {
        if (line == null) {
            throw new NullPointerException("line is marked non-null but is null");
        }
        return this.insertLine(this.size(), line);
    }

    public boolean insertLine(int index, @NonNull HologramLine line) {
        if (line == null) {
            throw new NullPointerException("line is marked non-null but is null");
        }
        if (index < 0 || index > this.size()) {
            return false;
        }
        this.lines.add(index, line);
        this.parent.getViewerPlayers(this.index).forEach(xva$0 -> line.show((Player)xva$0));
        this.realignLines();
        return true;
    }

    public boolean setLine(int index, @NonNull String content) {
        if (content == null) {
            throw new NullPointerException("content is marked non-null but is null");
        }
        HologramLine line = this.getLine(index);
        if (line == null) {
            return false;
        }
        HologramLineType previousType = line.getType();
        line.setContent(content);
        if (line.getType() != previousType) {
            line.hide(new Player[0]);
            line.show(new Player[0]);
            this.realignLines();
        }
        return true;
    }

    public HologramLine getLine(int index) {
        if (index < 0 || index >= this.size()) {
            return null;
        }
        return this.lines.get(index);
    }

    public HologramLine removeLine(int index) {
        if (index < 0 || index >= this.size()) {
            return null;
        }
        HologramLine line = this.lines.remove(index);
        if (line != null) {
            line.destroy();
            this.realignLines();
        }
        return line;
    }

    public boolean swapLines(int index1, int index2) {
        if (index1 < 0 || index1 >= this.size() || index2 < 0 || index2 >= this.size()) {
            return false;
        }
        Collections.swap(this.lines, index1, index2);
        this.realignLines();
        return true;
    }

    @NonNull
    public Location getNextLineLocation() {
        if (this.size() == 0) {
            return this.parent.getLocation().clone();
        }
        HologramLine line = this.lines.get(this.lines.size() - 1);
        return line.getLocation().clone().subtract(0.0, line.getHeight(), 0.0);
    }

    @NonNull
    public List<HologramLine> getLines() {
        return ImmutableList.copyOf(this.lines);
    }

    public boolean isClickable() {
        return !this.parent.hasFlag(EnumFlag.DISABLE_ACTIONS) && this.hasActions();
    }

    @Deprecated
    public int getClickableEntityId(int index) {
        return this.getClickableRenderer(index).getEntityId();
    }

    NmsClickableHologramRenderer getClickableRenderer(int index) {
        if (index >= this.clickableEntityRenderers.size()) {
            this.clickableEntityRenderers.add(DecentHologramsAPI.get().getNmsAdapter().getHologramComponentFactory().createClickableRenderer());
        }
        return this.clickableEntityRenderers.get(index);
    }

    public boolean hasEntity(int eid) {
        for (NmsClickableHologramRenderer clickableEntityRenderer : this.clickableEntityRenderers) {
            if (clickableEntityRenderer.getEntityId() != eid) continue;
            return true;
        }
        for (HologramLine line : this.lines) {
            for (int entityId : line.getEntityIds()) {
                if (entityId != eid) continue;
                return true;
            }
        }
        return false;
    }

    public void addAction(@NonNull ClickType clickType, @NonNull Action action) {
        if (clickType == null) {
            throw new NullPointerException("clickType is marked non-null but is null");
        }
        if (action == null) {
            throw new NullPointerException("action is marked non-null but is null");
        }
        this.actions.computeIfAbsent(clickType, k -> new ArrayList()).add(action);
    }

    public void executeActions(@NonNull Player player, @NonNull ClickType clickType) {
        if (player == null) {
            throw new NullPointerException("player is marked non-null but is null");
        }
        if (clickType == null) {
            throw new NullPointerException("clickType is marked non-null but is null");
        }
        if (!this.actions.containsKey((Object)clickType)) {
            return;
        }
        for (Action action : this.actions.get((Object)clickType)) {
            String actionName = action.getType().getName();
            String actionData = action.getData();
            if (actionName.contains("_PAGE") && actionData == null) {
                action.setData(this.getParent().getName());
            } else if (actionName.equals("PAGE") && actionData != null && actionData.matches("\\d+")) {
                action.setData(this.getParent().getName() + ":" + actionData);
            }
            if (!action.execute(player)) {
                action.setData(actionData);
                return;
            }
            action.setData(actionData);
        }
    }

    public void clearActions(@NonNull ClickType clickType) {
        if (clickType == null) {
            throw new NullPointerException("clickType is marked non-null but is null");
        }
        this.actions.remove((Object)clickType);
    }

    public void removeAction(@NonNull ClickType clickType, int index) {
        if (clickType == null) {
            throw new NullPointerException("clickType is marked non-null but is null");
        }
        this.actions.get((Object)clickType).remove(index);
    }

    public List<Action> getActions(@NonNull ClickType clickType) {
        if (clickType == null) {
            throw new NullPointerException("clickType is marked non-null but is null");
        }
        if (!this.actions.containsKey((Object)clickType)) {
            return new ArrayList<Action>();
        }
        return this.actions.get((Object)clickType);
    }

    public boolean hasActions() {
        for (ClickType value : ClickType.values()) {
            List<Action> list = this.actions.get((Object)value);
            if (list == null || list.isEmpty()) continue;
            return true;
        }
        return false;
    }

    @Generated
    public int getIndex() {
        return this.index;
    }

    @Generated
    public List<NmsClickableHologramRenderer> getClickableEntityRenderers() {
        return this.clickableEntityRenderers;
    }

    @Generated
    public Map<ClickType, List<Action>> getActions() {
        return this.actions;
    }

    @Generated
    public void setIndex(int index) {
        this.index = index;
    }
}

