/*
 * Decompiled with CFR 0.152.
 */
package eu.decentsoftware.holograms.api.listeners;

import eu.decentsoftware.holograms.api.holograms.DisableCause;
import eu.decentsoftware.holograms.api.holograms.Hologram;
import eu.decentsoftware.holograms.api.holograms.HologramManager;
import eu.decentsoftware.holograms.api.holograms.objects.HologramObject;
import eu.decentsoftware.holograms.api.utils.Log;
import eu.decentsoftware.holograms.api.utils.exception.LocationParseException;
import eu.decentsoftware.holograms.api.utils.scheduler.S;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.bukkit.World;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.world.WorldLoadEvent;
import org.bukkit.event.world.WorldUnloadEvent;

public class WorldListener
implements Listener {
    private final HologramManager hologramManager;

    public WorldListener(HologramManager hologramManager) {
        this.hologramManager = hologramManager;
    }

    @EventHandler
    public void onWorldUnload(WorldUnloadEvent event) {
        World world = event.getWorld();
        S.async(() -> this.hologramManager.getHolograms().stream().filter(HologramObject::isEnabled).filter(hologram -> hologram.getLocation().getWorld().equals(world)).forEach(hologram -> hologram.disable(DisableCause.WORLD_UNLOAD)));
    }

    @EventHandler
    public void onWorldLoad(WorldLoadEvent event) {
        World world = event.getWorld();
        S.async(() -> {
            Set<String> hologramsToLoad = this.getHologramsToLoadByWorld(world);
            if (!hologramsToLoad.isEmpty()) {
                hologramsToLoad.forEach(fileName -> {
                    try {
                        Hologram hologram = Hologram.fromFile(fileName);
                        if (hologram.isEnabled()) {
                            hologram.showAll();
                            hologram.realignLines();
                            this.hologramManager.registerHologram(hologram);
                        }
                    }
                    catch (LocationParseException ignored) {
                        Log.warn("Failed to load hologram from file: " + fileName);
                    }
                });
            }
            this.hologramManager.getHolograms().stream().filter(hologram -> !hologram.isEnabled()).filter(hologram -> hologram.getLocation().getWorld().equals(world)).filter(hologram -> hologram.getDisableCause().equals((Object)DisableCause.WORLD_UNLOAD)).forEach(Hologram::enable);
        });
    }

    private Set<String> getHologramsToLoadByWorld(World world) {
        HashSet<String> hologramsToLoad = new HashSet<String>();
        if (this.hologramManager.getToLoad().containsKey(world.getName())) {
            hologramsToLoad.addAll((Collection)this.hologramManager.getToLoad().get(world.getName()));
        }
        if (this.hologramManager.getToLoad().containsKey(world.getUID().toString())) {
            hologramsToLoad.addAll((Collection<String>)this.hologramManager.getToLoad().get(world.getUID().toString()));
        }
        return hologramsToLoad;
    }
}

