/*
 * Decompiled with CFR 0.152.
 */
package eu.decentsoftware.holograms.api.utils.config;

import eu.decentsoftware.holograms.api.utils.Log;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import lombok.Generated;
import org.bukkit.configuration.InvalidConfigurationException;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.plugin.java.JavaPlugin;
import org.jetbrains.annotations.NotNull;

public class FileConfig
extends YamlConfiguration {
    protected final JavaPlugin plugin;
    protected final String path;
    protected final File file;

    public FileConfig(@NotNull JavaPlugin plugin, @NotNull String path) {
        this.plugin = plugin;
        this.path = path;
        this.file = new File(plugin.getDataFolder(), path);
        this.createFile();
        this.loadData();
    }

    public FileConfig(@NotNull JavaPlugin plugin, @NotNull File file) {
        this.plugin = plugin;
        this.path = file.getName();
        this.file = file;
        this.createFile();
        this.loadData();
    }

    public void createFile() {
        if (!this.file.exists()) {
            this.plugin.getDataFolder().mkdirs();
            if (this.plugin.getResource(this.path) == null) {
                try {
                    this.file.createNewFile();
                }
                catch (IOException e) {
                    Log.warn("Failed to create config file at path '%s'.", e, this.path);
                }
            } else {
                this.plugin.saveResource(this.path, false);
            }
        }
    }

    public void saveData() {
        try {
            this.save(this.file);
        }
        catch (IOException e) {
            Log.warn("Failed to save config file at path '%s'.", e, this.path);
        }
    }

    @Deprecated
    public void reload() {
        try {
            this.load(this.file);
        }
        catch (IOException | InvalidConfigurationException e) {
            Log.warn("Failed to reload config file at path '%s'.", this.path);
        }
    }

    private void loadData() {
        try {
            this.load(this.file);
        }
        catch (IOException | InvalidConfigurationException e) {
            Log.warn("Failed to load config file at path '%s'.", this.path);
        }
    }

    public void delete() {
        if (this.file.exists()) {
            try {
                Files.delete(this.file.toPath());
            }
            catch (IOException e) {
                Log.warn("Failed to delete config file at path '%s'.", e, this.path);
            }
        }
    }

    @Generated
    public JavaPlugin getPlugin() {
        return this.plugin;
    }

    @Generated
    public String getPath() {
        return this.path;
    }

    @Generated
    public File getFile() {
        return this.file;
    }
}

