/*
 * Decompiled with CFR 0.152.
 */
package eu.decentsoftware.holograms.api.utils.event;

import eu.decentsoftware.holograms.api.actions.ClickType;
import eu.decentsoftware.holograms.api.holograms.Hologram;
import eu.decentsoftware.holograms.api.holograms.HologramPage;
import eu.decentsoftware.holograms.event.DecentHologramsReloadEvent;
import eu.decentsoftware.holograms.event.HologramClickEvent;
import eu.decentsoftware.holograms.event.HologramDisableEvent;
import eu.decentsoftware.holograms.event.HologramEnableEvent;
import eu.decentsoftware.holograms.event.HologramRegisterEvent;
import eu.decentsoftware.holograms.event.HologramUnregisterEvent;
import lombok.Generated;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;

public final class EventFactory {
    public static boolean fireHologramClickEvent(Player player, Hologram hologram, HologramPage page, ClickType clickType, int entityId) {
        if (HologramClickEvent.getHandlerList().getRegisteredListeners().length == 0) {
            return true;
        }
        HologramClickEvent event = new HologramClickEvent(player, hologram, page, clickType, entityId);
        Bukkit.getPluginManager().callEvent((Event)event);
        return !event.isCancelled();
    }

    public static void fireReloadEvent() {
        if (DecentHologramsReloadEvent.getHandlerList().getRegisteredListeners().length == 0) {
            return;
        }
        DecentHologramsReloadEvent event = new DecentHologramsReloadEvent();
        Bukkit.getPluginManager().callEvent((Event)event);
    }

    public static void fireHologramRegisterEvent(Hologram hologram) {
        if (HologramRegisterEvent.getHandlerList().getRegisteredListeners().length == 0) {
            return;
        }
        HologramRegisterEvent event = new HologramRegisterEvent(!Bukkit.isPrimaryThread(), hologram);
        Bukkit.getPluginManager().callEvent((Event)event);
    }

    public static void fireHologramUnregisterEvent(Hologram hologram) {
        if (HologramUnregisterEvent.getHandlerList().getRegisteredListeners().length == 0) {
            return;
        }
        HologramUnregisterEvent event = new HologramUnregisterEvent(!Bukkit.isPrimaryThread(), hologram);
        Bukkit.getPluginManager().callEvent((Event)event);
    }

    public static void fireHologramEnableEvent(Hologram hologram) {
        if (HologramEnableEvent.getHandlerList().getRegisteredListeners().length == 0) {
            return;
        }
        HologramEnableEvent event = new HologramEnableEvent(!Bukkit.isPrimaryThread(), hologram);
        Bukkit.getPluginManager().callEvent((Event)event);
    }

    public static void fireHologramDisableEvent(Hologram hologram) {
        if (HologramDisableEvent.getHandlerList().getRegisteredListeners().length == 0) {
            return;
        }
        HologramDisableEvent event = new HologramDisableEvent(!Bukkit.isPrimaryThread(), hologram);
        Bukkit.getPluginManager().callEvent((Event)event);
    }

    @Generated
    private EventFactory() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

