/*
 * Decompiled with CFR 0.152.
 */
package eu.decentsoftware.holograms.api.utils.items;

import eu.decentsoftware.holograms.api.utils.Common;
import eu.decentsoftware.holograms.api.utils.reflect.ReflectMethod;
import eu.decentsoftware.holograms.api.utils.reflect.ReflectionUtil;
import eu.decentsoftware.holograms.api.utils.reflect.Version;
import eu.decentsoftware.holograms.libs.xseries.XMaterial;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import lombok.Generated;
import org.bukkit.Material;

public final class DecentMaterial {
    private static final Map<String, String> MATERIAL_ALIASES = new HashMap<String, String>();
    private static final ReflectMethod MATERIAL_IS_ITEM_METHOD;

    public static Material parseMaterial(String materialName) {
        Material materialFromAliases = Material.getMaterial((String)MATERIAL_ALIASES.get(Common.removeSpacingChars(materialName).toLowerCase()));
        if (materialFromAliases != null) {
            return materialFromAliases;
        }
        Optional<XMaterial> xMaterialOptional = XMaterial.matchXMaterial(materialName);
        return xMaterialOptional.map(XMaterial::get).orElse(null);
    }

    public static boolean isItem(Material material) {
        if (Version.afterOrEqual(13)) {
            return (Boolean)MATERIAL_IS_ITEM_METHOD.invoke(material, new Object[0]);
        }
        return MATERIAL_IS_ITEM_METHOD.invokeStatic(material.getId()) != null;
    }

    @Generated
    private DecentMaterial() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }

    static {
        for (Material material : Material.values()) {
            MATERIAL_ALIASES.put(Common.removeSpacingChars(material.name()).toLowerCase(), material.name());
        }
        MATERIAL_IS_ITEM_METHOD = Version.before(13) ? new ReflectMethod(ReflectionUtil.getNMSClass("Item"), "getById", Integer.TYPE) : new ReflectMethod(Material.class, "isItem", new Class[0]);
    }
}

