/*
 * Decompiled with CFR 0.152.
 */
package eu.decentsoftware.holograms.hook;

import eu.decentsoftware.holograms.api.utils.Log;
import eu.decentsoftware.holograms.api.utils.PAPI;
import eu.decentsoftware.holograms.api.utils.reflect.Version;
import eu.decentsoftware.holograms.libs.nbtapi.NBT;
import eu.decentsoftware.holograms.libs.nbtapi.iface.ReadWriteNBT;
import eu.decentsoftware.holograms.libs.nbtapi.iface.ReadableNBTList;
import eu.decentsoftware.holograms.libs.nbtapi.utils.DataFixerUtil;
import lombok.Generated;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;

public final class NbtApiHook {
    private static boolean loadedSuccessfully;

    public static void initialize() {
        loadedSuccessfully = NBT.preloadApi();
        if (!loadedSuccessfully) {
            Log.warn("NBT-API could not be loaded. Custom NBT in items may not work as expected.");
        } else {
            Log.info("NBT-API loaded successfully.");
        }
    }

    public static ItemStack applyNbtDataToItemStack(ItemStack itemStack, String nbt, Player player) {
        if (!loadedSuccessfully) {
            return itemStack;
        }
        try {
            ReadWriteNBT originalNBT = NBT.itemStackToNBT(itemStack);
            ReadWriteNBT modifiableNBT = NBT.itemStackToNBT(itemStack);
            modifiableNBT.getOrCreateCompound("tag").mergeCompound(NBT.parseNBT(player == null ? nbt : PAPI.setPlaceholders(player, nbt)));
            modifiableNBT.setByte("Count", (byte)1);
            modifiableNBT = DataFixerUtil.fixUpItemData(modifiableNBT, 3700, DataFixerUtil.getCurrentVersion());
            modifiableNBT.mergeCompound(originalNBT);
            return NBT.itemStackFromNBT(modifiableNBT);
        }
        catch (Exception ex) {
            Log.warn("Failed to apply NBT Data to Item: %s", ex, nbt);
            return itemStack;
        }
    }

    public static float extractCustomModelData(ItemStack itemStack) {
        ReadableNBTList floats;
        if (!loadedSuccessfully) {
            return 0.0f;
        }
        ReadWriteNBT nbtItem = NBT.itemStackToNBT(itemStack);
        float customModelData = Version.afterOrEqual(Version.v1_21_R3) ? ((floats = nbtItem.getOrCreateCompound("components").getOrCreateCompound("minecraft:custom_model_data").getFloatList("floats")).isEmpty() ? 0.0f : ((Float)floats.get(0)).floatValue()) : (Version.afterOrEqual(Version.v1_20_R4) ? (float)nbtItem.getOrCreateCompound("components").getInteger("minecraft:custom_model_data").intValue() : (float)nbtItem.getOrCreateCompound("tag").getInteger("CustomModelData").intValue());
        return customModelData;
    }

    @Generated
    private NbtApiHook() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

