/*
 * Decompiled with CFR 0.152.
 */
package eu.decentsoftware.holograms.integration;

import eu.decentsoftware.holograms.api.DecentHologramsAPI;
import eu.decentsoftware.holograms.integration.IntegrationAvailabilityService;
import org.jetbrains.annotations.Nullable;

public enum Integration {
    PLACEHOLDER_API("PlaceholderAPI"),
    HEAD_DATABASE("HeadDatabase");

    private final String pluginName;

    private Integration(String pluginName) {
        this.pluginName = pluginName;
    }

    public String getPluginName() {
        return this.pluginName;
    }

    public boolean isAvailable() {
        IntegrationAvailabilityService integrationAvailabilityService = DecentHologramsAPI.get().getIntegrationAvailabilityService();
        return integrationAvailabilityService.isIntegrationAvailable(this);
    }

    @Nullable
    public static Integration getByPluginName(String pluginName) {
        for (Integration integration : Integration.values()) {
            if (!integration.getPluginName().equalsIgnoreCase(pluginName)) continue;
            return integration;
        }
        return null;
    }
}

