/*
 * Decompiled with CFR 0.152.
 */
package eu.decentsoftware.holograms.integration;

import eu.decentsoftware.holograms.integration.Integration;
import eu.decentsoftware.holograms.integration.IntegrationAvailabilityService;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.server.PluginDisableEvent;
import org.bukkit.event.server.PluginEnableEvent;
import org.bukkit.plugin.Plugin;

class IntegrationAvailabilityListener
implements Listener {
    private final IntegrationAvailabilityService service;

    IntegrationAvailabilityListener(IntegrationAvailabilityService service) {
        this.service = service;
    }

    @EventHandler
    void onPluginEnable(PluginEnableEvent event) {
        this.updateIntegrationAvailability(event.getPlugin(), true);
    }

    @EventHandler
    void onPluginDisable(PluginDisableEvent event) {
        this.updateIntegrationAvailability(event.getPlugin(), false);
    }

    private void updateIntegrationAvailability(Plugin plugin, boolean available) {
        String pluginName = plugin.getName();
        Integration integration = Integration.getByPluginName(pluginName);
        if (integration != null) {
            this.service.setIntegrationAvailability(integration, available);
        }
    }
}

