/*
 * Decompiled with CFR 0.152.
 */
package eu.decentsoftware.holograms.integration;

import com.google.common.base.Preconditions;
import eu.decentsoftware.holograms.integration.Integration;
import eu.decentsoftware.holograms.integration.IntegrationAvailabilityListener;
import java.util.EnumMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import org.bukkit.Bukkit;
import org.bukkit.event.HandlerList;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.PluginManager;
import org.bukkit.plugin.java.JavaPlugin;

public class IntegrationAvailabilityService {
    private final Map<Integration, AtomicBoolean> integrationsAvailability = new EnumMap<Integration, AtomicBoolean>(Integration.class);
    private final JavaPlugin plugin;
    private final PluginManager pluginManager;
    private final IntegrationAvailabilityListener integrationAvailabilityListener;
    private boolean initialized = false;

    public IntegrationAvailabilityService(JavaPlugin plugin, PluginManager pluginManager) {
        Preconditions.checkNotNull((Object)plugin, (Object)"plugin cannot be null");
        Preconditions.checkNotNull((Object)pluginManager, (Object)"pluginManager cannot be null");
        this.plugin = plugin;
        this.pluginManager = pluginManager;
        this.integrationAvailabilityListener = new IntegrationAvailabilityListener(this);
    }

    public void initialize() {
        if (!Bukkit.isPrimaryThread()) {
            throw new IllegalStateException("This method must be called from the Main thread.");
        }
        if (this.initialized) {
            throw new IllegalStateException("IntegrationAvailabilityService has already been initialized.");
        }
        this.initialized = true;
        this.populateInitialAvailabilities();
        this.pluginManager.registerEvents((Listener)this.integrationAvailabilityListener, (Plugin)this.plugin);
    }

    private void populateInitialAvailabilities() {
        for (Integration integration : Integration.values()) {
            boolean available = this.pluginManager.isPluginEnabled(integration.getPluginName());
            this.integrationsAvailability.put(integration, new AtomicBoolean(available));
        }
    }

    public void shutdown() {
        HandlerList.unregisterAll((Listener)this.integrationAvailabilityListener);
    }

    public boolean isIntegrationAvailable(Integration integration) {
        Preconditions.checkNotNull((Object)((Object)integration), (Object)"integration cannot be null");
        this.checkInitialized();
        AtomicBoolean availabilityStatus = this.integrationsAvailability.get((Object)integration);
        return availabilityStatus != null && availabilityStatus.get();
    }

    void setIntegrationAvailability(Integration integration, boolean available) {
        Preconditions.checkNotNull((Object)((Object)integration), (Object)"integration cannot be null");
        this.checkInitialized();
        AtomicBoolean availabilityStatus = this.integrationsAvailability.get((Object)integration);
        if (availabilityStatus != null) {
            availabilityStatus.set(available);
        }
    }

    private void checkInitialized() {
        if (!this.initialized) {
            throw new IllegalStateException("IntegrationAvailabilityService has not been initialized.");
        }
    }
}

