/*
 * Decompiled with CFR 0.152.
 */
package eu.decentsoftware.holograms.nms;

import eu.decentsoftware.holograms.nms.NmsPlayerListener;
import eu.decentsoftware.holograms.nms.api.NmsAdapter;
import eu.decentsoftware.holograms.nms.api.NmsPacketListener;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.event.HandlerList;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

public class NmsPacketListenerService {
    private final NmsAdapter nmsAdapter;
    private final NmsPacketListener packetListener;
    private final NmsPlayerListener playerListener;

    public NmsPacketListenerService(JavaPlugin plugin, NmsAdapter nmsAdapter, NmsPacketListener packetListener) {
        this.nmsAdapter = nmsAdapter;
        this.packetListener = packetListener;
        this.playerListener = new NmsPlayerListener(this);
        Bukkit.getPluginManager().registerEvents((Listener)this.playerListener, (Plugin)plugin);
        this.registerListenerForAllPlayers();
    }

    public void shutdown() {
        HandlerList.unregisterAll((Listener)this.playerListener);
        this.unregisterListenerForAllPlayers();
    }

    void registerListener(Player player) {
        this.nmsAdapter.registerPacketListener(player, this.packetListener);
    }

    void unregisterListener(Player player) {
        this.nmsAdapter.unregisterPacketListener(player);
    }

    private void registerListenerForAllPlayers() {
        Bukkit.getOnlinePlayers().forEach(this::registerListener);
    }

    private void unregisterListenerForAllPlayers() {
        Bukkit.getOnlinePlayers().forEach(this::unregisterListener);
    }
}

