/*
 * Decompiled with CFR 0.152.
 */
package eu.decentsoftware.holograms.nms.v1_19_R1;

import eu.decentsoftware.holograms.nms.api.DecentHologramsNmsException;
import eu.decentsoftware.holograms.nms.api.NmsAdapter;
import eu.decentsoftware.holograms.nms.api.NmsPacketListener;
import eu.decentsoftware.holograms.nms.api.renderer.NmsHologramRendererFactory;
import eu.decentsoftware.holograms.nms.v1_19_R1.EntityIdGenerator;
import eu.decentsoftware.holograms.nms.v1_19_R1.HologramRendererFactory;
import eu.decentsoftware.holograms.nms.v1_19_R1.InboundPacketHandler;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.EventLoop;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.function.Consumer;
import org.bukkit.craftbukkit.v1_19_R1.entity.CraftPlayer;
import org.bukkit.entity.Player;

public class NmsAdapterImpl
implements NmsAdapter {
    private static final String PACKET_HANDLER_NAME = "decent_holograms_packet_handler";
    private static final String DEFAULT_PIPELINE_TAIL = "DefaultChannelPipeline$TailContext#0";
    private final HologramRendererFactory hologramComponentFactory = new HologramRendererFactory(new EntityIdGenerator());

    @Override
    public NmsHologramRendererFactory getHologramComponentFactory() {
        return this.hologramComponentFactory;
    }

    @Override
    public void registerPacketListener(Player player, NmsPacketListener listener) {
        Objects.requireNonNull(player, "player cannot be null");
        Objects.requireNonNull(listener, "listener cannot be null");
        this.executeOnPipelineInEventLoop(player, pipeline -> {
            if (pipeline.get(PACKET_HANDLER_NAME) != null) {
                pipeline.remove(PACKET_HANDLER_NAME);
            }
            pipeline.addBefore("packet_handler", PACKET_HANDLER_NAME, (ChannelHandler)new InboundPacketHandler(player, listener));
        });
    }

    @Override
    public void unregisterPacketListener(Player player) {
        Objects.requireNonNull(player, "player cannot be null");
        this.executeOnPipelineInEventLoop(player, pipeline -> {
            if (pipeline.get(PACKET_HANDLER_NAME) != null) {
                pipeline.remove(PACKET_HANDLER_NAME);
            }
        });
    }

    private void executeOnPipelineInEventLoop(Player player, Consumer<ChannelPipeline> task) {
        ChannelPipeline pipeline = this.getPipeline(player);
        EventLoop eventLoop = pipeline.channel().eventLoop();
        if (eventLoop.inEventLoop()) {
            this.executeOnPipeline(player, task, pipeline);
        } else {
            eventLoop.execute(() -> this.executeOnPipeline(player, task, pipeline));
        }
    }

    private ChannelPipeline getPipeline(Player player) {
        return ((CraftPlayer)player).getHandle().b.a().m.pipeline();
    }

    private void executeOnPipeline(Player player, Consumer<ChannelPipeline> task, ChannelPipeline pipeline) {
        if (!player.isOnline()) {
            return;
        }
        try {
            task.accept(pipeline);
        }
        catch (NoSuchElementException e) {
            List handlers = pipeline.names();
            if (handlers.size() == 1 && ((String)handlers.get(0)).equals(DEFAULT_PIPELINE_TAIL)) {
                return;
            }
            this.throwFailedToModifyPipelineException(player, e);
        }
        catch (Exception e) {
            this.throwFailedToModifyPipelineException(player, e);
        }
    }

    private void throwFailedToModifyPipelineException(Player player, Exception e) {
        throw new DecentHologramsNmsException("Failed to modify player's pipeline. player: " + player.getName(), e);
    }
}

