/*
 * Decompiled with CFR 0.152.
 */
package eu.decentsoftware.holograms.nms.v1_19_R1;

import io.netty.buffer.Unpooled;
import java.util.List;
import net.minecraft.network.PacketDataSerializer;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.syncher.DataWatcher;

class PacketDataSerializerWrapper {
    private static final ThreadLocal<PacketDataSerializerWrapper> LOCAL_INSTANCE = ThreadLocal.withInitial(PacketDataSerializerWrapper::new);
    private final PacketDataSerializer serializer = new PacketDataSerializer(Unpooled.buffer());

    private PacketDataSerializerWrapper() {
    }

    PacketDataSerializer getSerializer() {
        return this.serializer;
    }

    void clear() {
        this.serializer.clear();
    }

    void writeIntArray(int[] value) {
        this.serializer.a(value);
    }

    void writeVarInt(int value) {
        this.serializer.d(value);
    }

    void writeByte(int value) {
        this.serializer.writeByte(value);
    }

    void writeDouble(double value) {
        this.serializer.writeDouble(value);
    }

    void writeBoolean(boolean value) {
        this.serializer.writeBoolean(value);
    }

    void writeWatchableObjects(List<DataWatcher.Item<?>> watchableObjects) {
        DataWatcher.a(watchableObjects, (PacketDataSerializer)this.serializer);
    }

    void writePacket(Packet<?> packet) {
        packet.a(this.serializer);
    }

    int readVarInt() {
        return this.serializer.k();
    }

    static PacketDataSerializerWrapper getInstance() {
        PacketDataSerializerWrapper instance = LOCAL_INSTANCE.get();
        instance.clear();
        return instance;
    }
}

