/*
 * Decompiled with CFR 0.152.
 */
package eu.decentsoftware.holograms.nms.v1_8_R1;

import eu.decentsoftware.holograms.nms.api.NmsHologramPartData;
import eu.decentsoftware.holograms.nms.api.renderer.NmsEntityHologramRenderer;
import eu.decentsoftware.holograms.nms.v1_8_R1.DataWatcherBuilder;
import eu.decentsoftware.holograms.nms.v1_8_R1.EntityIdGenerator;
import eu.decentsoftware.holograms.nms.v1_8_R1.EntityPacketsBuilder;
import eu.decentsoftware.holograms.nms.v1_8_R1.EntityTypeRegistry;
import eu.decentsoftware.holograms.shared.DecentPosition;
import net.minecraft.server.v1_8_R1.DataWatcher;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Player;

class EntityHologramRenderer
implements NmsEntityHologramRenderer {
    private final EntityIdGenerator entityIdGenerator;
    private int entityId;
    private final int armorStandEntityId;
    private final DataWatcher armorStandDataWatcher;

    EntityHologramRenderer(EntityIdGenerator entityIdGenerator) {
        this.entityIdGenerator = entityIdGenerator;
        this.entityId = entityIdGenerator.getFreeEntityId();
        this.armorStandEntityId = entityIdGenerator.getFreeEntityId();
        this.armorStandDataWatcher = DataWatcherBuilder.create().withInvisible().withArmorStandProperties(true, true).toDataWatcher();
    }

    @Override
    public synchronized void display(Player player, NmsHologramPartData<EntityType> data) {
        DecentPosition position = data.getPosition();
        EntityType content = data.getContent();
        EntityPacketsBuilder.create().withSpawnEntityLiving(this.armorStandEntityId, EntityType.ARMOR_STAND, this.offsetPosition(position), this.armorStandDataWatcher).withSpawnEntityLivingOrObject(this.entityId, content, position).withTeleportEntity(this.entityId, position).attachEntity(this.entityId, this.armorStandEntityId).sendTo(player);
    }

    @Override
    public synchronized void updateContent(Player player, NmsHologramPartData<EntityType> data) {
        int oldEntityId = this.entityId;
        this.entityId = this.entityIdGenerator.getFreeEntityId();
        DecentPosition position = data.getPosition();
        EntityType content = data.getContent();
        EntityPacketsBuilder.create().unattachEntity(this.entityId).withRemoveEntity(oldEntityId).withSpawnEntityLivingOrObject(this.entityId, content, position).withTeleportEntity(this.entityId, position).attachEntity(this.entityId, this.armorStandEntityId).sendTo(player);
    }

    @Override
    public synchronized void move(Player player, NmsHologramPartData<EntityType> data) {
        DecentPosition position = data.getPosition();
        EntityPacketsBuilder.create().withTeleportEntity(this.armorStandEntityId, this.offsetPosition(position)).withEntityHeadLook(this.entityId, position.getYaw()).sendTo(player);
    }

    @Override
    public synchronized void hide(Player player) {
        EntityPacketsBuilder.create().unattachEntity(this.entityId).withRemoveEntity(this.entityId).withRemoveEntity(this.armorStandEntityId).sendTo(player);
    }

    @Override
    public double getHeight(NmsHologramPartData<EntityType> data) {
        return EntityTypeRegistry.getEntityTypeHeight(data.getContent());
    }

    @Override
    public synchronized int[] getEntityIds() {
        return new int[]{this.armorStandEntityId, this.entityId};
    }

    private DecentPosition offsetPosition(DecentPosition position) {
        return position.subtractY(1.65);
    }
}

