/*
 * Decompiled with CFR 0.152.
 */
package eu.decentsoftware.holograms.nms.v1_8_R1;

import com.google.common.base.Strings;
import eu.decentsoftware.holograms.nms.v1_8_R1.EntityMetadataType;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.server.v1_8_R1.WatchableObject;
import org.bukkit.craftbukkit.v1_8_R1.inventory.CraftItemStack;
import org.bukkit.inventory.ItemStack;

class EntityMetadataBuilder {
    private final List<WatchableObject> watchableObjects = new ArrayList<WatchableObject>();

    private EntityMetadataBuilder() {
    }

    List<WatchableObject> toWatchableObjects() {
        return this.watchableObjects;
    }

    EntityMetadataBuilder withCustomName(String customName) {
        this.watchableObjects.add(EntityMetadataType.ENTITY_CUSTOM_NAME.construct(customName));
        boolean visible = !Strings.isNullOrEmpty((String)customName);
        this.watchableObjects.add(EntityMetadataType.ENTITY_CUSTOM_NAME_VISIBLE.construct(this.booleanToByte(visible)));
        return this;
    }

    EntityMetadataBuilder withItemStack(ItemStack itemStack) {
        this.watchableObjects.add(EntityMetadataType.ITEM_STACK.construct(CraftItemStack.asNMSCopy((ItemStack)itemStack)));
        return this;
    }

    private byte booleanToByte(boolean visible) {
        return (byte)(visible ? 1 : 0);
    }

    static EntityMetadataBuilder create() {
        return new EntityMetadataBuilder();
    }
}

