/*
 * Decompiled with CFR 0.152.
 */
package eu.decentsoftware.holograms.nms.v1_8_R1;

import eu.decentsoftware.holograms.nms.api.DecentHologramsNmsException;
import java.util.EnumMap;
import java.util.Map;
import org.bukkit.entity.EntityType;

final class EntityTypeRegistry {
    private static final Map<EntityType, EntityTypeInfo> ENTITY_TYPE_INFO_MAP = new EnumMap<EntityType, EntityTypeInfo>(EntityType.class);

    private EntityTypeRegistry() {
        throw new IllegalStateException("Utility class");
    }

    private static void register(EntityType entityType, int typeId, double height) {
        ENTITY_TYPE_INFO_MAP.put(entityType, new EntityTypeInfo(typeId, height));
    }

    static int getEntityTypeId(EntityType entityType) {
        EntityTypeInfo entityTypeInfo = ENTITY_TYPE_INFO_MAP.get(entityType);
        if (entityTypeInfo == null) {
            throw new DecentHologramsNmsException("Invalid entity type: " + entityType);
        }
        return entityTypeInfo.getTypeId();
    }

    static double getEntityTypeHeight(EntityType entityType) {
        EntityTypeInfo entityTypeInfo = ENTITY_TYPE_INFO_MAP.get(entityType);
        if (entityTypeInfo == null) {
            throw new DecentHologramsNmsException("Invalid entity type: " + entityType);
        }
        return entityTypeInfo.getHeight();
    }

    static {
        EntityTypeRegistry.register(EntityType.ARMOR_STAND, 30, 2.0);
        EntityTypeRegistry.register(EntityType.CREEPER, 50, 1.8f);
        EntityTypeRegistry.register(EntityType.SKELETON, 51, 1.95f);
        EntityTypeRegistry.register(EntityType.SPIDER, 52, 0.9f);
        EntityTypeRegistry.register(EntityType.GIANT, 53, 10.799999237060547);
        EntityTypeRegistry.register(EntityType.ZOMBIE, 54, 1.95f);
        EntityTypeRegistry.register(EntityType.SLIME, 55, 0.5100000500679016);
        EntityTypeRegistry.register(EntityType.GHAST, 56, 4.0);
        EntityTypeRegistry.register(EntityType.PIG_ZOMBIE, 57, 1.95f);
        EntityTypeRegistry.register(EntityType.ENDERMAN, 58, 2.9f);
        EntityTypeRegistry.register(EntityType.CAVE_SPIDER, 59, 0.5);
        EntityTypeRegistry.register(EntityType.SILVERFISH, 60, 0.3f);
        EntityTypeRegistry.register(EntityType.BLAZE, 61, 1.8f);
        EntityTypeRegistry.register(EntityType.MAGMA_CUBE, 62, 0.5100000500679016);
        EntityTypeRegistry.register(EntityType.ENDER_DRAGON, 63, 8.0);
        EntityTypeRegistry.register(EntityType.WITHER, 64, 3.5);
        EntityTypeRegistry.register(EntityType.BAT, 65, 0.9f);
        EntityTypeRegistry.register(EntityType.WITCH, 66, 1.95f);
        EntityTypeRegistry.register(EntityType.ENDERMITE, 67, 0.3f);
        EntityTypeRegistry.register(EntityType.GUARDIAN, 68, 0.85f);
        EntityTypeRegistry.register(EntityType.PIG, 90, 0.9f);
        EntityTypeRegistry.register(EntityType.SHEEP, 91, 1.3f);
        EntityTypeRegistry.register(EntityType.COW, 92, 1.3f);
        EntityTypeRegistry.register(EntityType.CHICKEN, 93, 0.7f);
        EntityTypeRegistry.register(EntityType.SQUID, 94, 0.95f);
        EntityTypeRegistry.register(EntityType.WOLF, 95, 0.8f);
        EntityTypeRegistry.register(EntityType.MUSHROOM_COW, 96, 1.3f);
        EntityTypeRegistry.register(EntityType.SNOWMAN, 97, 1.9f);
        EntityTypeRegistry.register(EntityType.OCELOT, 98, 0.8f);
        EntityTypeRegistry.register(EntityType.IRON_GOLEM, 99, 2.9f);
        EntityTypeRegistry.register(EntityType.HORSE, 100, 1.6f);
        EntityTypeRegistry.register(EntityType.RABBIT, 101, 0.7f);
        EntityTypeRegistry.register(EntityType.VILLAGER, 120, 1.8f);
        EntityTypeRegistry.register(EntityType.BOAT, 1, 0.6f);
        EntityTypeRegistry.register(EntityType.DROPPED_ITEM, 2, 0.25);
        EntityTypeRegistry.register(EntityType.MINECART, 10, 0.7f);
        EntityTypeRegistry.register(EntityType.PRIMED_TNT, 50, 0.98f);
        EntityTypeRegistry.register(EntityType.ENDER_CRYSTAL, 51, 2.0);
        EntityTypeRegistry.register(EntityType.ARROW, 60, 0.5);
        EntityTypeRegistry.register(EntityType.SNOWBALL, 61, 0.25);
        EntityTypeRegistry.register(EntityType.EGG, 62, 0.25);
        EntityTypeRegistry.register(EntityType.FALLING_BLOCK, 70, 0.98f);
        EntityTypeRegistry.register(EntityType.FIREBALL, 63, 1.0);
        EntityTypeRegistry.register(EntityType.SMALL_FIREBALL, 64, 0.3125);
        EntityTypeRegistry.register(EntityType.ENDER_PEARL, 65, 0.25);
        EntityTypeRegistry.register(EntityType.WITHER_SKULL, 66, 0.3125);
        EntityTypeRegistry.register(EntityType.ITEM_FRAME, 71, 0.98f);
        EntityTypeRegistry.register(EntityType.ENDER_SIGNAL, 72, 0.25);
        EntityTypeRegistry.register(EntityType.SPLASH_POTION, 73, 0.25);
        EntityTypeRegistry.register(EntityType.THROWN_EXP_BOTTLE, 75, 0.25);
        EntityTypeRegistry.register(EntityType.FIREWORK, 76, 0.25);
        EntityTypeRegistry.register(EntityType.LEASH_HITCH, 77, 0.5);
    }

    private static class EntityTypeInfo {
        private final int typeId;
        private final double height;

        EntityTypeInfo(int typeId, double height) {
            this.typeId = typeId;
            this.height = height;
        }

        int getTypeId() {
            return this.typeId;
        }

        double getHeight() {
            return this.height;
        }
    }
}

