/*
 * Decompiled with CFR 0.152.
 */
package eu.decentsoftware.holograms.plugin.convertors;

import eu.decentsoftware.holograms.api.convertor.IConvertor;
import eu.decentsoftware.holograms.plugin.convertors.impl.CMIConverter;
import eu.decentsoftware.holograms.plugin.convertors.impl.FutureHologramsConverter;
import eu.decentsoftware.holograms.plugin.convertors.impl.GHoloConverter;
import eu.decentsoftware.holograms.plugin.convertors.impl.HologramsConvertor;
import eu.decentsoftware.holograms.plugin.convertors.impl.HolographicDisplaysConvertor;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import lombok.Generated;
import org.jetbrains.annotations.Nullable;

public enum ConvertorType {
    CMI(true, "CMI", new String[0]),
    FUTURE_HOLOGRAMS(true, "FutureHolograms", "fh", "fholograms"),
    GHOLO(false, "GHolo", "gh"),
    HOLOGRAPHIC_DISPLAYS(false, "HolographicDisplays", "hd"),
    HOLOGRAMS(true, "Holograms", new String[0]);

    private final String name;
    private final List<String> aliases;
    private final boolean limited;

    @Nullable
    public static ConvertorType fromString(String alias) {
        for (ConvertorType convertorType : ConvertorType.values()) {
            if (!convertorType.getName().equalsIgnoreCase(alias) && !convertorType.getAliases().contains(alias.toLowerCase(Locale.ROOT))) continue;
            return convertorType;
        }
        return null;
    }

    private ConvertorType(boolean limited, String name, String ... aliases) {
        this.limited = limited;
        this.name = name;
        this.aliases = aliases == null ? Collections.emptyList() : Arrays.asList(aliases);
    }

    @Nullable
    public IConvertor getConvertor() {
        switch (this) {
            case CMI: {
                return new CMIConverter();
            }
            case FUTURE_HOLOGRAMS: {
                return new FutureHologramsConverter();
            }
            case GHOLO: {
                return new GHoloConverter();
            }
            case HOLOGRAPHIC_DISPLAYS: {
                return new HolographicDisplaysConvertor();
            }
            case HOLOGRAMS: {
                return new HologramsConvertor();
            }
        }
        return null;
    }

    @Generated
    public String getName() {
        return this.name;
    }

    @Generated
    public List<String> getAliases() {
        return this.aliases;
    }

    @Generated
    public boolean isLimited() {
        return this.limited;
    }
}

