/*
 * Decompiled with CFR 0.152.
 */
package eu.decentsoftware.holograms.shared.reflect;

import eu.decentsoftware.holograms.shared.reflect.DecentHologramsReflectException;
import java.lang.reflect.Field;

public class ReflectField<T> {
    private final Class<?> parentClass;
    private final String fieldName;
    private Field field;

    public ReflectField(Class<?> clazz, String fieldName) {
        this.parentClass = clazz;
        this.fieldName = fieldName;
    }

    public T get(Object instance) {
        this.initializeField();
        try {
            return (T)this.field.get(instance);
        }
        catch (IllegalAccessException e) {
            throw new DecentHologramsReflectException("Could not get value of field '" + this.fieldName + "' in class " + this.parentClass.getName(), e);
        }
    }

    public void set(Object instance, T value) {
        this.initializeField();
        try {
            this.field.set(instance, value);
        }
        catch (IllegalAccessException e) {
            throw new DecentHologramsReflectException("Could not set value of field '" + this.fieldName + "' in class " + this.parentClass.getName(), e);
        }
    }

    private void initializeField() {
        if (this.field != null) {
            return;
        }
        try {
            this.field = this.findField(this.parentClass, this.fieldName);
            this.field.setAccessible(true);
        }
        catch (NoSuchFieldException e) {
            throw new DecentHologramsReflectException("Could not find field '" + this.fieldName + "' in class " + this.parentClass.getName(), e);
        }
    }

    private Field findField(Class<?> clazz, String fieldName) throws NoSuchFieldException {
        Field foundField;
        try {
            foundField = clazz.getDeclaredField(fieldName);
        }
        catch (NoSuchFieldException e) {
            foundField = clazz.getField(fieldName);
        }
        return foundField;
    }
}

