/*
 * Decompiled with CFR 0.152.
 */
package eu.decentsoftware.holograms.shared.reflect;

import com.google.common.reflect.TypeToken;
import eu.decentsoftware.holograms.shared.DecentHologramsException;
import java.lang.reflect.Field;

public class ReflectUtil {
    public static boolean isPaper = false;

    private ReflectUtil() {
        throw new IllegalAccessError("Utility class");
    }

    public static <T> T getFieldValue(Class<?> clazz, String fieldName) {
        try {
            Field field = clazz.getDeclaredField(fieldName);
            field.setAccessible(true);
            return (T)field.get(null);
        }
        catch (NoSuchFieldException e) {
            throw new DecentHologramsException("Could not find field " + fieldName + " in class " + clazz.getName(), e);
        }
        catch (IllegalAccessException e) {
            throw new DecentHologramsException("Could not access field " + fieldName + " in class " + clazz.getName(), e);
        }
        catch (ClassCastException e) {
            Class expectedFieldType = new TypeToken<T>(){}.getRawType();
            throw new DecentHologramsException("Could not cast value of field " + fieldName + " in class " + clazz.getName() + " to " + expectedFieldType.getName(), e);
        }
        catch (Exception e) {
            throw new DecentHologramsException("Unexpected error occurred while getting value of field " + fieldName + " in class " + clazz.getName(), e);
        }
    }

    public static Class<?> getClass(String className) throws ClassNotFoundException {
        return Class.forName(className);
    }

    static {
        try {
            ReflectUtil.getClass("io.papermc.paper.PaperBootstrap");
            isPaper = true;
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
    }
}

