/*
 * Decompiled with CFR 0.152.
 */
package eu.decentsoftware.holograms.skin;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import eu.decentsoftware.holograms.api.utils.Log;
import eu.decentsoftware.holograms.skin.SkinSource;
import eu.decentsoftware.holograms.skin.SkinSourceException;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import org.jetbrains.annotations.NotNull;

public class SkinService {
    private static final Cache<String, String> textureCache = CacheBuilder.newBuilder().expireAfterWrite(1L, TimeUnit.HOURS).build();
    private final SkinSource skinSource;

    public SkinService(@NotNull SkinSource skinSource) {
        Objects.requireNonNull(skinSource, "skinSource cannot be null");
        this.skinSource = skinSource;
    }

    public String getSkinTextureByPlayerName(@NotNull String playerName) {
        Objects.requireNonNull(playerName, "playerName cannot be null");
        String cachedTexture = (String)textureCache.getIfPresent((Object)playerName);
        if (cachedTexture != null) {
            return cachedTexture;
        }
        try {
            String fetchedTexture = this.skinSource.fetchSkinTextureByPlayerName(playerName);
            textureCache.put((Object)playerName, (Object)fetchedTexture);
            return fetchedTexture;
        }
        catch (SkinSourceException e) {
            Log.warn("Error fetching skin texture: %s", e.getMessage());
        }
        catch (Exception e) {
            Log.error("An unexpected error occurred while fetching skin texture for player '%s'.", e, playerName);
        }
        return null;
    }
}

