/*
 * Decompiled with CFR 0.152.
 */
package eu.decentsoftware.holograms.api;

import com.google.common.collect.ImmutableMap;
import eu.decentsoftware.holograms.api.DecentHolograms;
import eu.decentsoftware.holograms.api.DecentHologramsAPI;
import eu.decentsoftware.holograms.api.utils.config.CFG;
import eu.decentsoftware.holograms.api.utils.config.FileConfig;
import eu.decentsoftware.holograms.api.utils.config.Key;
import java.util.HashMap;
import java.util.Map;
import lombok.Generated;
import org.bukkit.configuration.ConfigurationSection;

public final class Settings {
    private static final DecentHolograms DECENT_HOLOGRAMS = DecentHologramsAPI.get();
    private static FileConfig config;
    @Key(value="update-checker")
    public static boolean CHECK_FOR_UPDATES;
    @Key(value="click-cooldown", min=1.0, max=300.0)
    public static int CLICK_COOLDOWN;
    @Key(value="defaults.text")
    public static String DEFAULT_TEXT;
    @Key(value="defaults.down-origin")
    public static boolean DEFAULT_DOWN_ORIGIN;
    @Key(value="defaults.height.text", min=0.0, max=2.5)
    public static double DEFAULT_HEIGHT_TEXT;
    @Key(value="defaults.height.icon", min=0.0, max=2.5)
    public static double DEFAULT_HEIGHT_ICON;
    @Key(value="defaults.height.head", min=0.0, max=2.5)
    public static double DEFAULT_HEIGHT_HEAD;
    @Key(value="defaults.height.smallhead", min=0.0, max=2.5)
    public static double DEFAULT_HEIGHT_SMALLHEAD;
    @Key(value="defaults.display-range", min=1.0, max=48.0)
    public static int DEFAULT_DISPLAY_RANGE;
    @Key(value="defaults.update-range", min=1.0, max=48.0)
    public static int DEFAULT_UPDATE_RANGE;
    @Key(value="defaults.update-interval", min=1.0, max=1200.0)
    public static int DEFAULT_UPDATE_INTERVAL;
    @Key(value="defaults.lru-cache-size", min=5.0, max=10000.0)
    public static int DEFAULT_LRU_CACHE_SIZE;
    @Key(value="allow-placeholders-inside-animations")
    public static boolean ALLOW_PLACEHOLDERS_INSIDE_ANIMATIONS;
    @Key(value="update-visibility-on-teleport")
    public static boolean UPDATE_VISIBILITY_ON_TELEPORT;
    @Key(value="holograms-eye-level-positioning")
    public static boolean HOLOGRAMS_EYE_LEVEL_POSITIONING;
    @Key(value="player-skin-connection-timeout", min=1.0, max=60.0)
    public static int PLAYER_SKIN_CONNECTION_TIMEOUT;
    public static Map<String, String> CUSTOM_REPLACEMENTS;

    public static void reload() {
        config = new FileConfig(DECENT_HOLOGRAMS.getPlugin(), "config.yml");
        CFG.load(DECENT_HOLOGRAMS.getPlugin(), Settings.class, config.getFile());
        ConfigurationSection customReplacementsSection = config.getConfigurationSection("custom-replacements");
        if (customReplacementsSection != null) {
            HashMap<String, String> replacements = new HashMap<String, String>();
            for (String key : customReplacementsSection.getKeys(false)) {
                if (!customReplacementsSection.isString(key)) continue;
                replacements.put(key, customReplacementsSection.getString(key));
            }
            CUSTOM_REPLACEMENTS = replacements;
        }
    }

    public static FileConfig getConfig() {
        return config;
    }

    @Generated
    private Settings() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }

    static {
        CHECK_FOR_UPDATES = true;
        CLICK_COOLDOWN = 1;
        DEFAULT_TEXT = "Blank Line";
        DEFAULT_DOWN_ORIGIN = false;
        DEFAULT_HEIGHT_TEXT = 0.3;
        DEFAULT_HEIGHT_ICON = 0.6;
        DEFAULT_HEIGHT_HEAD = 0.75;
        DEFAULT_HEIGHT_SMALLHEAD = 0.6;
        DEFAULT_DISPLAY_RANGE = 48;
        DEFAULT_UPDATE_RANGE = 48;
        DEFAULT_UPDATE_INTERVAL = 20;
        DEFAULT_LRU_CACHE_SIZE = 500;
        ALLOW_PLACEHOLDERS_INSIDE_ANIMATIONS = false;
        UPDATE_VISIBILITY_ON_TELEPORT = false;
        HOLOGRAMS_EYE_LEVEL_POSITIONING = false;
        PLAYER_SKIN_CONNECTION_TIMEOUT = 5;
        CUSTOM_REPLACEMENTS = ImmutableMap.builder().put((Object)"[x]", (Object)"\u2588").put((Object)"[X]", (Object)"\u2588").put((Object)"[/]", (Object)"\u258c").put((Object)"[,]", (Object)"\u2591").put((Object)"[,,]", (Object)"\u2592").put((Object)"[,,,]", (Object)"\u2593").put((Object)"[p]", (Object)"\u2022").put((Object)"[P]", (Object)"\u2022").put((Object)"[|]", (Object)"\u23b9").build();
    }
}

