/*
 * Decompiled with CFR 0.152.
 */
package eu.decentsoftware.holograms.api.commands;

import eu.decentsoftware.holograms.api.DecentHologramsAPI;
import eu.decentsoftware.holograms.api.commands.DecentCommand;
import eu.decentsoftware.holograms.api.utils.reflect.ReflectField;
import eu.decentsoftware.holograms.api.utils.reflect.ReflectMethod;
import eu.decentsoftware.holograms.api.utils.reflect.ReflectionUtil;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.bukkit.command.Command;
import org.bukkit.command.SimpleCommandMap;

public class CommandManager {
    private final Map<String, DecentCommand> commands = new HashMap<String, DecentCommand>();
    private DecentCommand mainCommand;
    private static final Class<?> CRAFT_SERVER_CLASS = ReflectionUtil.getObcClass("CraftServer");
    private static final ReflectMethod GET_COMMAND_MAP_METHOD = new ReflectMethod(CRAFT_SERVER_CLASS, "getCommandMap", new Class[0]);
    private static final ReflectField<Map<String, Command>> COMMAND_MAP_KNOWN_COMMANDS_FIELD = new ReflectField(SimpleCommandMap.class, "knownCommands");

    public void destroy() {
        if (!this.commands.isEmpty()) {
            this.commands.values().forEach(CommandManager::unregister);
            this.commands.clear();
        }
    }

    public void registerCommand(DecentCommand decentCommand) {
        if (this.commands.containsKey(decentCommand.getName())) {
            return;
        }
        this.commands.put(decentCommand.getName(), decentCommand);
        CommandManager.register(decentCommand);
    }

    public void unregisterCommand(String name) {
        if (!this.commands.containsKey(name)) {
            return;
        }
        DecentCommand decentCommand = this.commands.remove(name);
        CommandManager.unregister(decentCommand);
    }

    public void setMainCommand(DecentCommand decentCommand) {
        this.mainCommand = decentCommand;
    }

    public DecentCommand getMainCommand() {
        return this.mainCommand;
    }

    public Set<String> getCommandNames() {
        return this.commands.keySet();
    }

    public Collection<DecentCommand> getCommands() {
        return this.commands.values();
    }

    public static void register(Command command) {
        if (command == null) {
            return;
        }
        SimpleCommandMap commandMap = (SimpleCommandMap)GET_COMMAND_MAP_METHOD.invoke(DecentHologramsAPI.get().getPlugin().getServer(), new Object[0]);
        CommandManager.unregister(command);
        commandMap.register("DecentHolograms", command);
    }

    public static void unregister(Command command) {
        if (command == null) {
            return;
        }
        SimpleCommandMap commandMap = (SimpleCommandMap)GET_COMMAND_MAP_METHOD.invoke(DecentHologramsAPI.get().getPlugin().getServer(), new Object[0]);
        Map<String, Command> cmdMap = COMMAND_MAP_KNOWN_COMMANDS_FIELD.getValue(commandMap);
        if (cmdMap != null && !cmdMap.isEmpty()) {
            cmdMap.remove(command.getLabel());
            for (String alias : command.getAliases()) {
                cmdMap.remove(alias);
            }
        }
    }
}

