/*
 * Decompiled with CFR 0.152.
 */
package eu.decentsoftware.holograms.api.commands;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import eu.decentsoftware.holograms.api.DecentHolograms;
import eu.decentsoftware.holograms.api.DecentHologramsAPI;
import eu.decentsoftware.holograms.api.Lang;
import eu.decentsoftware.holograms.api.commands.CommandBase;
import eu.decentsoftware.holograms.api.commands.CommandInfo;
import eu.decentsoftware.holograms.api.commands.CommandValidator;
import eu.decentsoftware.holograms.api.commands.DecentCommandException;
import eu.decentsoftware.holograms.api.commands.TabCompleteHandler;
import eu.decentsoftware.holograms.api.utils.Common;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.apache.commons.lang.Validate;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;

public abstract class DecentCommand
extends Command
implements CommandBase {
    protected static final DecentHolograms PLUGIN = DecentHologramsAPI.get();
    protected final Map<String, CommandBase> subCommands = new LinkedHashMap<String, CommandBase>();
    protected final CommandInfo info = this.getClass().getAnnotation(CommandInfo.class);

    protected DecentCommand(String name) {
        super(name);
        if (this.info == null) {
            throw new DecentCommandException(String.format("Command %s is not annotated with @CommandInfo.", name));
        }
        this.setAliases(Arrays.asList(this.info.aliases()));
    }

    @Override
    public Set<String> getSubCommandNames() {
        return Collections.emptySet();
    }

    @Override
    public Collection<CommandBase> getSubCommands() {
        return this.subCommands.values();
    }

    @Override
    public CommandBase getSubCommand(String name) {
        Validate.notNull((Object)name);
        return this.subCommands.get(name);
    }

    @Override
    public CommandBase addSubCommand(CommandBase commandBase) {
        this.subCommands.put(commandBase.getName(), commandBase);
        return this;
    }

    public boolean execute(CommandSender sender, String s, String[] args) {
        try {
            return this.handle(sender, args);
        }
        catch (DecentCommandException e) {
            Common.tell(sender, e.getMessage());
            return true;
        }
    }

    public List<String> tabComplete(CommandSender sender, String alias, String[] args) throws IllegalArgumentException {
        return this.handleTabComplete(sender, args);
    }

    @Override
    public String[] getPermissions() {
        return this.info.permissions();
    }

    @Override
    public boolean isPlayerOnly() {
        return this.info.playerOnly();
    }

    @Override
    public int getMinArgs() {
        return this.info.minArgs();
    }

    @Override
    public String getUsage() {
        return this.info.usage();
    }

    @Override
    public String getDescription() {
        return this.info.description();
    }

    protected void printHelpSubCommandsAndAliases(CommandSender sender, CommandBase command) {
        this.printHelpSubCommandsAndAliases(sender, command, subCommand -> true);
    }

    protected void printHelpSubCommandsAndAliases(CommandSender sender, CommandBase command, Predicate<CommandBase> subCommandFilter) {
        List helpSubCommands = command.getSubCommands().stream().filter(subCommandFilter).collect(Collectors.toList());
        for (CommandBase subCommand : helpSubCommands) {
            Common.tell(sender, " &8\u2022 &b" + subCommand.getUsage() + " &8- &7" + subCommand.getDescription());
        }
        sender.sendMessage("");
        Common.tell(sender, " &7Aliases: &b" + this.getAliasesFormatted(command));
        sender.sendMessage("");
    }

    private String getAliasesFormatted(CommandBase command) {
        return command.getName() + (command.getAliases().size() > 1 ? ", " + String.join((CharSequence)", ", command.getAliases()) : "");
    }

    protected final boolean handle(CommandSender sender, String[] args) throws DecentCommandException {
        if (!CommandValidator.canExecute(sender, this)) {
            return true;
        }
        if (args.length != 0) {
            for (CommandBase subCommand : this.getSubCommands()) {
                if (!CommandValidator.isIdentifier(args[0], subCommand)) continue;
                String[] subCommandArgs = Arrays.copyOfRange(args, 1, args.length);
                if (subCommandArgs.length < subCommand.getMinArgs()) {
                    Lang.COMMAND_USAGE.send(sender, subCommand.getUsage());
                    return true;
                }
                return ((DecentCommand)subCommand).handle(sender, subCommandArgs);
            }
        } else if (this.getMinArgs() > 0) {
            Lang.COMMAND_USAGE.send(sender, this.getUsage());
            return false;
        }
        return this.getCommandHandler().handle(sender, args);
    }

    @Deprecated
    protected final List<String> handeTabComplete(CommandSender sender, String[] args) {
        return this.handleTabComplete(sender, args);
    }

    protected final List<String> handleTabComplete(CommandSender sender, String[] args) {
        if (this.getPermission() != null && !sender.hasPermission(this.getPermission())) {
            return ImmutableList.of();
        }
        if (args.length == 1) {
            ArrayList<String> subs = new ArrayList<String>();
            this.getSubCommands().forEach(cmd -> {
                subs.add(cmd.getName());
                subs.addAll(Lists.newArrayList(cmd.getAliases()));
            });
            List<String> matches = TabCompleteHandler.getPartialMatches(args[0], subs);
            if (!matches.isEmpty()) {
                Collections.sort(matches);
                return matches;
            }
        } else if (args.length > 1) {
            for (CommandBase subCommand : this.getSubCommands()) {
                if (!CommandValidator.isIdentifier(args[0], subCommand)) continue;
                return ((DecentCommand)subCommand).handleTabComplete(sender, Arrays.copyOfRange(args, 1, args.length));
            }
        }
        if (this.getTabCompleteHandler() == null) {
            return ImmutableList.of();
        }
        return this.getTabCompleteHandler().handleTabComplete(sender, args);
    }
}

