/*
 * Decompiled with CFR 0.152.
 */
package eu.decentsoftware.holograms.api.utils;

import java.util.Objects;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.TestOnly;

public final class Log {
    private static Logger logger;

    private Log() {
        throw new UnsupportedOperationException("Utility class cannot be instantiated");
    }

    public static void setLogger(@NotNull Logger logger) {
        Objects.requireNonNull(logger, "logger cannot be null");
        if (Log.logger != null) {
            throw new IllegalStateException("Logger is already set. Cannot set it again.");
        }
        Log.logger = logger;
    }

    public static void info(String message) {
        Log.checkLoggerAvailable();
        logger.info(message);
    }

    public static void info(String message, Object ... args) {
        Log.checkLoggerAvailable();
        logger.info(() -> String.format(message, args));
    }

    public static void info(String message, Throwable throwable) {
        Log.checkLoggerAvailable();
        logger.log(Level.INFO, message, throwable);
    }

    public static void info(String message, Throwable throwable, Object ... args) {
        Log.checkLoggerAvailable();
        logger.log(Level.INFO, throwable, () -> String.format(message, args));
    }

    public static void warn(String message) {
        Log.checkLoggerAvailable();
        logger.warning(message);
    }

    public static void warn(String message, Object ... args) {
        Log.checkLoggerAvailable();
        logger.warning(() -> String.format(message, args));
    }

    public static void warn(String message, Throwable throwable) {
        Log.checkLoggerAvailable();
        logger.log(Level.WARNING, message, throwable);
    }

    public static void warn(String message, Throwable throwable, Object ... args) {
        Log.checkLoggerAvailable();
        logger.log(Level.WARNING, throwable, () -> String.format(message, args));
    }

    public static void error(String message) {
        Log.checkLoggerAvailable();
        logger.severe(message);
    }

    public static void error(String message, Object ... args) {
        Log.checkLoggerAvailable();
        logger.severe(() -> String.format(message, args));
    }

    public static void error(String message, Throwable throwable) {
        Log.checkLoggerAvailable();
        logger.log(Level.SEVERE, message, throwable);
    }

    public static void error(String message, Throwable throwable, Object ... args) {
        Log.checkLoggerAvailable();
        logger.log(Level.SEVERE, throwable, () -> String.format(message, args));
    }

    private static void checkLoggerAvailable() {
        if (logger == null) {
            throw new IllegalStateException("Logger is not set. Please set a logger using Log#setLogger before using logging methods.");
        }
    }

    @TestOnly
    public static void initializeForTests() {
        if (logger == null) {
            logger = Logger.getLogger("DecentHolograms");
        }
    }
}

