/*
 * Decompiled with CFR 0.152.
 */
package eu.decentsoftware.holograms.api.utils.color.caching;

import eu.decentsoftware.holograms.api.utils.color.caching.LruElement;
import java.util.Deque;
import java.util.LinkedList;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.concurrent.ThreadSafe;
import lombok.Generated;

@ThreadSafe
public class LruCache {
    private final Deque<String> QUE = new LinkedList<String>();
    private final Map<String, LruElement> MAP = new ConcurrentHashMap<String, LruElement>();
    private final int maxSize;

    public LruCache(int maxSize) {
        this.maxSize = maxSize;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getResult(String input) {
        if (input != null && this.MAP.containsKey(input)) {
            LruElement curr = this.MAP.get(input);
            Deque<String> deque = this.QUE;
            synchronized (deque) {
                this.QUE.remove(input);
                this.QUE.addFirst(input);
            }
            return curr.getResult();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void put(String input, String result) {
        if (input == null || result == null) {
            return;
        }
        Deque<String> deque = this.QUE;
        synchronized (deque) {
            if (this.MAP.containsKey(input)) {
                this.QUE.remove(input);
            } else {
                int size = this.QUE.size();
                if (size == this.maxSize && size > 0) {
                    String temp = this.QUE.removeLast();
                    this.MAP.remove(temp);
                }
            }
            LruElement newObj = new LruElement(input, result);
            this.QUE.addFirst(input);
            this.MAP.put(input, newObj);
        }
    }

    @Generated
    public Deque<String> getQUE() {
        return this.QUE;
    }

    @Generated
    public Map<String, LruElement> getMAP() {
        return this.MAP;
    }

    @Generated
    public int getMaxSize() {
        return this.maxSize;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof LruCache)) {
            return false;
        }
        LruCache other = (LruCache)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getMaxSize() != other.getMaxSize()) {
            return false;
        }
        Deque<String> this$QUE = this.getQUE();
        Deque<String> other$QUE = other.getQUE();
        if (this$QUE == null ? other$QUE != null : !this$QUE.equals(other$QUE)) {
            return false;
        }
        Map<String, LruElement> this$MAP = this.getMAP();
        Map<String, LruElement> other$MAP = other.getMAP();
        return !(this$MAP == null ? other$MAP != null : !((Object)this$MAP).equals(other$MAP));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof LruCache;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getMaxSize();
        Deque<String> $QUE = this.getQUE();
        result = result * 59 + ($QUE == null ? 43 : $QUE.hashCode());
        Map<String, LruElement> $MAP = this.getMAP();
        result = result * 59 + ($MAP == null ? 43 : ((Object)$MAP).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "LruCache(QUE=" + this.getQUE() + ", MAP=" + this.getMAP() + ", maxSize=" + this.getMaxSize() + ")";
    }
}

