/*
 * Decompiled with CFR 0.152.
 */
package eu.decentsoftware.holograms.api.utils.config;

import eu.decentsoftware.holograms.api.utils.config.FileConfig;

public class ConfigValue<T> {
    protected final boolean setDefault;
    protected final String path;
    protected final T defaultValue;
    protected T value;

    public ConfigValue(boolean setDefault, String path, T defaultValue) {
        this.setDefault = setDefault;
        this.path = path;
        this.defaultValue = defaultValue;
    }

    public ConfigValue(String path, T defaultValue) {
        this(true, path, defaultValue);
    }

    public void updateValue(FileConfig config) {
        if (!config.contains(this.path)) {
            this.value = this.defaultValue;
            if (this.setDefault) {
                config.set(this.path, this.defaultValue);
                config.saveData();
            }
        } else {
            Object o = config.get(this.path);
            try {
                this.value = o;
            }
            catch (Exception e) {
                e.printStackTrace();
                this.value = this.defaultValue;
            }
        }
    }

    public String getPath() {
        return this.path;
    }

    public T getDefaultValue() {
        return this.defaultValue;
    }

    public T getValue() {
        return this.value == null ? this.defaultValue : this.value;
    }

    public void setValue(T value) {
        this.value = value;
    }
}

