/*
 * Decompiled with CFR 0.152.
 */
package eu.decentsoftware.holograms.api.utils.file;

import eu.decentsoftware.holograms.api.utils.Log;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import lombok.Generated;
import lombok.NonNull;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class FileUtils {
    @NotNull
    public static List<File> getFilesFromTree(@NotNull File root, @Nullable String regex, boolean createDir) {
        ArrayList<File> files = new ArrayList<File>();
        if (root.exists() && root.isDirectory()) {
            File[] children = root.listFiles();
            if (children != null) {
                for (File child : children) {
                    if (child.isDirectory()) {
                        files.addAll(FileUtils.getFilesFromTree(child, regex, createDir));
                        continue;
                    }
                    if (regex != null && !regex.trim().isEmpty() && !child.getName().matches(regex)) continue;
                    files.add(child);
                }
            }
        } else if (createDir && root.mkdirs()) {
            Log.info("Created directory %s", root.getPath());
        }
        return files;
    }

    @Nullable
    public static String getRelativePath(@NonNull File file, @NonNull File base) {
        String basePath;
        if (file == null) {
            throw new NullPointerException("file is marked non-null but is null");
        }
        if (base == null) {
            throw new NullPointerException("base is marked non-null but is null");
        }
        String filePath = file.getAbsolutePath();
        if (filePath.startsWith(basePath = base.getAbsolutePath())) {
            return filePath.substring(basePath.length() + 1);
        }
        return null;
    }

    @Generated
    private FileUtils() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

