/*
 * Decompiled with CFR 0.152.
 */
package eu.decentsoftware.holograms.api.utils.items;

import eu.decentsoftware.holograms.api.utils.HeadDatabaseUtils;
import eu.decentsoftware.holograms.api.utils.Log;
import eu.decentsoftware.holograms.api.utils.PAPI;
import eu.decentsoftware.holograms.api.utils.items.DecentMaterial;
import eu.decentsoftware.holograms.api.utils.items.ItemBuilder;
import eu.decentsoftware.holograms.api.utils.reflect.Version;
import eu.decentsoftware.holograms.hook.NbtApiHook;
import java.util.Map;
import lombok.Generated;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.Validate;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.SkullType;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;

public class HologramItem {
    private static final String ENCHANTED_INDICATOR = "!ENCHANTED";
    private final String content;
    private String nbt;
    private String extras;
    private Material material;
    private short durability = 0;
    private boolean enchanted = false;

    public HologramItem(String string) {
        this.content = string;
        this.parseContent();
    }

    public ItemStack parse(Player player) {
        try {
            String extrasFinal;
            ItemBuilder itemBuilder = new ItemBuilder(this.material);
            if (this.durability > 0) {
                itemBuilder.withDurability(this.durability);
            }
            if ((this.material.name().contains("SKULL") || this.material.name().contains("HEAD")) && StringUtils.isNotEmpty((String)(extrasFinal = this.parseExtras(player)))) {
                if (extrasFinal.startsWith("HEADDATABASE_") && Bukkit.getPluginManager().isPluginEnabled("HeadDatabase")) {
                    String headDatabaseId = extrasFinal.substring("HEADDATABASE_".length());
                    itemBuilder.withItemStack(HeadDatabaseUtils.getHeadItemStackById(headDatabaseId));
                } else if (extrasFinal.length() <= 16) {
                    itemBuilder.withSkullOwner(extrasFinal);
                } else {
                    itemBuilder.withSkullTexture(extrasFinal);
                }
                itemBuilder.withDurability((short)SkullType.PLAYER.ordinal());
            }
            if (this.enchanted) {
                itemBuilder.withUnsafeEnchantment(Enchantment.DURABILITY, 1);
            }
            ItemStack itemStack = itemBuilder.toItemStack();
            if (this.nbt != null) {
                itemStack = this.applyNBT(player, itemStack);
            }
            return itemStack;
        }
        catch (Exception e) {
            Log.warn("Error parsing item: %s", e, this.content);
            return new ItemStack(Material.STONE);
        }
    }

    private String parseExtras(Player player) {
        if (this.extras == null) {
            return null;
        }
        String extrasFinal = player == null ? this.extras.trim() : PAPI.setPlaceholders(player, this.extras).trim();
        extrasFinal = extrasFinal.replace("{player}", player == null ? "" : player.getName());
        return extrasFinal;
    }

    private ItemStack applyNBT(Player player, ItemStack itemStack) {
        if (Version.afterOrEqual(Version.v1_20_R4)) {
            return NbtApiHook.applyNbtDataToItemStack(itemStack, this.nbt, player);
        }
        try {
            Bukkit.getUnsafe().modifyItemStack(itemStack, this.nbt);
        }
        catch (Exception ex) {
            Log.warn("Failed to apply NBT Data to Item: %s", ex, this.nbt);
        }
        return itemStack;
    }

    private void parseContent() {
        String string = this.content;
        string = this.findExtras(string);
        string = this.findNBT(string);
        string = this.checkEnchanted(string);
        this.parseMaterial(string);
        if (this.material == null) {
            this.material = Material.STONE;
        }
    }

    private void parseMaterial(String string) {
        String materialString;
        String materialName = materialString = string.trim().split(" ", 2)[0];
        if (materialString.contains(":")) {
            String[] materialStringSpl = materialString.split(":", 2);
            materialName = materialStringSpl[0];
            try {
                this.durability = Short.parseShort(materialStringSpl[1]);
            }
            catch (Exception e) {
                this.durability = 0;
            }
        }
        this.material = DecentMaterial.parseMaterial(materialName);
    }

    private String checkEnchanted(String string) {
        if (string.contains(ENCHANTED_INDICATOR)) {
            string = string.replace(ENCHANTED_INDICATOR, "");
            this.enchanted = true;
        }
        return string;
    }

    private String findNBT(String string) {
        if (string.contains("{") && string.contains("}")) {
            int nbtStart = string.indexOf(123);
            int nbtEnd = string.lastIndexOf(125);
            if (nbtStart > 0 && nbtEnd > 0 && nbtEnd > nbtStart) {
                this.nbt = string.substring(nbtStart, nbtEnd + 1);
                string = string.substring(0, nbtStart) + string.substring(nbtEnd + 1);
            }
        }
        return string;
    }

    private String findExtras(String string) {
        if (string.contains("(") && string.contains(")")) {
            int extrasStart = string.indexOf(40);
            int extrasEnd = string.lastIndexOf(41);
            if (extrasStart > 0 && extrasEnd > 0 && extrasEnd > extrasStart) {
                this.extras = string.substring(extrasStart + 1, extrasEnd);
                string = string.substring(0, extrasStart) + string.substring(extrasEnd + 1);
            }
        }
        return string;
    }

    public static HologramItem fromItemStack(ItemStack itemStack) {
        float customModelData;
        Validate.notNull((Object)itemStack);
        StringBuilder stringBuilder = new StringBuilder();
        ItemBuilder itemBuilder = new ItemBuilder(itemStack);
        Material material = itemStack.getType();
        stringBuilder.append(material.name());
        short durability = itemStack.getDurability();
        if (durability > 0) {
            stringBuilder.append(":").append(durability);
        }
        stringBuilder.append(" ");
        Map enchants = itemStack.getEnchantments();
        if (enchants != null && !enchants.isEmpty()) {
            stringBuilder.append(ENCHANTED_INDICATOR).append(" ");
        }
        if (material.name().contains("HEAD") || material.name().contains("SKULL")) {
            String owner = itemBuilder.getSkullOwner();
            String texture = itemBuilder.getSkullTexture();
            if (texture != null) {
                stringBuilder.append("(").append(texture).append(")");
            } else if (owner != null && !owner.isEmpty()) {
                stringBuilder.append("(").append(owner).append(")");
            }
        }
        if ((double)(customModelData = NbtApiHook.extractCustomModelData(itemStack)) > 0.0) {
            stringBuilder.append("{CustomModelData:").append(customModelData).append('}');
        }
        return new HologramItem(stringBuilder.toString());
    }

    public static ItemStack parseItemStack(String string, Player player) {
        string = PAPI.setPlaceholders(player, string);
        return new HologramItem(string).parse(player);
    }

    @Generated
    public String getContent() {
        return this.content;
    }

    @Generated
    public String getNbt() {
        return this.nbt;
    }

    @Generated
    public String getExtras() {
        return this.extras;
    }

    @Generated
    public Material getMaterial() {
        return this.material;
    }

    @Generated
    public short getDurability() {
        return this.durability;
    }

    @Generated
    public boolean isEnchanted() {
        return this.enchanted;
    }

    @Generated
    public void setNbt(String nbt) {
        this.nbt = nbt;
    }

    @Generated
    public void setExtras(String extras) {
        this.extras = extras;
    }

    @Generated
    public void setMaterial(Material material) {
        this.material = material;
    }

    @Generated
    public void setDurability(short durability) {
        this.durability = durability;
    }

    @Generated
    public void setEnchanted(boolean enchanted) {
        this.enchanted = enchanted;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof HologramItem)) {
            return false;
        }
        HologramItem other = (HologramItem)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getDurability() != other.getDurability()) {
            return false;
        }
        if (this.isEnchanted() != other.isEnchanted()) {
            return false;
        }
        String this$content = this.getContent();
        String other$content = other.getContent();
        if (this$content == null ? other$content != null : !this$content.equals(other$content)) {
            return false;
        }
        String this$nbt = this.getNbt();
        String other$nbt = other.getNbt();
        if (this$nbt == null ? other$nbt != null : !this$nbt.equals(other$nbt)) {
            return false;
        }
        String this$extras = this.getExtras();
        String other$extras = other.getExtras();
        if (this$extras == null ? other$extras != null : !this$extras.equals(other$extras)) {
            return false;
        }
        Material this$material = this.getMaterial();
        Material other$material = other.getMaterial();
        return !(this$material == null ? other$material != null : !this$material.equals(other$material));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof HologramItem;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getDurability();
        result = result * 59 + (this.isEnchanted() ? 79 : 97);
        String $content = this.getContent();
        result = result * 59 + ($content == null ? 43 : $content.hashCode());
        String $nbt = this.getNbt();
        result = result * 59 + ($nbt == null ? 43 : $nbt.hashCode());
        String $extras = this.getExtras();
        result = result * 59 + ($extras == null ? 43 : $extras.hashCode());
        Material $material = this.getMaterial();
        result = result * 59 + ($material == null ? 43 : $material.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "HologramItem(content=" + this.getContent() + ", nbt=" + this.getNbt() + ", extras=" + this.getExtras() + ", material=" + this.getMaterial() + ", durability=" + this.getDurability() + ", enchanted=" + this.isEnchanted() + ")";
    }

    @Generated
    public HologramItem(String content, String nbt, String extras, Material material, short durability, boolean enchanted) {
        this.content = content;
        this.nbt = nbt;
        this.extras = extras;
        this.material = material;
        this.durability = durability;
        this.enchanted = enchanted;
    }
}

