/*
 * Decompiled with CFR 0.152.
 */
package eu.decentsoftware.holograms.api.utils.items;

import com.mojang.authlib.GameProfile;
import com.mojang.authlib.properties.Property;
import com.mojang.authlib.properties.PropertyMap;
import eu.decentsoftware.holograms.api.utils.Log;
import eu.decentsoftware.holograms.api.utils.reflect.ReflectionUtil;
import eu.decentsoftware.holograms.api.utils.reflect.Version;
import eu.decentsoftware.holograms.libs.xseries.profiles.builder.XSkull;
import eu.decentsoftware.holograms.libs.xseries.profiles.objects.Profileable;
import eu.decentsoftware.holograms.skin.SkinService;
import eu.decentsoftware.holograms.skin.mojang.MojangSkinSource;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.UUID;
import java.util.function.Function;
import lombok.Generated;
import lombok.NonNull;
import org.bukkit.SkullType;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.SkullMeta;
import org.jetbrains.annotations.Nullable;

public final class SkullUtils {
    private static final SkinService skinService = new SkinService(new MojangSkinSource());
    private static final String RESOLVABLE_PROFILE_CLASS_PATH = "net.minecraft.world.item.component.ResolvableProfile";
    private static Field profileField;
    private static Method setProfileMethod;
    private static boolean initialized;
    private static Constructor<?> resolvableProfileConstructor;
    private static Field gameProfileFieldResolvableProfile;
    private static Function<Property, String> valueResolver;

    @Nullable
    public static String getSkullTexture(@NonNull ItemStack itemStack) {
        if (itemStack == null) {
            throw new NullPointerException("itemStack is marked non-null but is null");
        }
        if (!(itemStack.getItemMeta() instanceof SkullMeta)) {
            return null;
        }
        if (Version.after(Version.v1_21_R5)) {
            return XSkull.of(itemStack).getProfileValue();
        }
        try {
            PropertyMap properties;
            Collection property2;
            Object profileObject;
            ItemMeta meta = itemStack.getItemMeta();
            if (!(meta instanceof SkullMeta)) {
                return null;
            }
            if (profileField == null) {
                profileField = meta.getClass().getDeclaredField("profile");
                profileField.setAccessible(true);
            }
            if ((profileObject = profileField.get(meta)) == null) {
                return null;
            }
            GameProfile profile = (GameProfile)(gameProfileFieldResolvableProfile == null ? profileObject : gameProfileFieldResolvableProfile.get(profileObject));
            if (profile == null) {
                return null;
            }
            if (valueResolver == null) {
                try {
                    Property.class.getMethod("getValue", new Class[0]);
                    valueResolver = Property::getValue;
                }
                catch (NoSuchMethodException ignored) {
                    Method propertyValueMethod = Property.class.getMethod("value", new Class[0]);
                    valueResolver = property -> {
                        try {
                            return (String)propertyValueMethod.invoke(property, new Object[0]);
                        }
                        catch (IllegalAccessException | InvocationTargetException e) {
                            Log.error("Failed to invoke Property#value", e);
                            return null;
                        }
                    };
                }
            }
            if ((property2 = (properties = profile.getProperties()).get((Object)"textures")) != null && !property2.isEmpty()) {
                return valueResolver.apply((Property)property2.iterator().next());
            }
        }
        catch (Exception e) {
            Log.error("An exception occurred while retrieving skull texture", e);
        }
        return null;
    }

    @Deprecated
    @Nullable
    public static String getTexture(@NonNull ItemStack itemStack) {
        if (itemStack == null) {
            throw new NullPointerException("itemStack is marked non-null but is null");
        }
        return SkullUtils.getSkullTexture(itemStack);
    }

    public static void setSkullTexture(@NonNull ItemStack itemStack, @NonNull String texture) {
        if (itemStack == null) {
            throw new NullPointerException("itemStack is marked non-null but is null");
        }
        if (texture == null) {
            throw new NullPointerException("texture is marked non-null but is null");
        }
        if (!(itemStack.getItemMeta() instanceof SkullMeta)) {
            return;
        }
        if (Version.after(Version.v1_21_R5)) {
            XSkull.of(itemStack).profile(Profileable.detect(texture)).apply();
            return;
        }
        try {
            ItemMeta meta = itemStack.getItemMeta();
            if (meta instanceof SkullMeta) {
                GameProfile profile = new GameProfile(UUID.randomUUID(), "");
                Property property = new Property("textures", texture);
                PropertyMap properties = profile.getProperties();
                properties.put((Object)"textures", (Object)property);
                if (setProfileMethod == null && !initialized) {
                    try {
                        setProfileMethod = meta.getClass().getDeclaredMethod("setProfile", resolvableProfileConstructor == null ? GameProfile.class : resolvableProfileConstructor.getDeclaringClass());
                        setProfileMethod.setAccessible(true);
                    }
                    catch (NoSuchMethodException noSuchMethodException) {
                        // empty catch block
                    }
                    initialized = true;
                }
                if (setProfileMethod != null) {
                    setProfileMethod.invoke((Object)meta, resolvableProfileConstructor == null ? profile : resolvableProfileConstructor.newInstance(profile));
                } else {
                    if (profileField == null) {
                        profileField = meta.getClass().getDeclaredField("profile");
                        profileField.setAccessible(true);
                    }
                    profileField.set(meta, profile);
                }
            }
            itemStack.setItemMeta(meta);
            if (Version.before(13)) {
                itemStack.setDurability((short)SkullType.PLAYER.ordinal());
            }
        }
        catch (Exception e) {
            Log.error("An exception occurred while setting skull texture", e);
        }
    }

    @Nullable
    public static String getSkullOwner(@NonNull ItemStack itemStack) {
        if (itemStack == null) {
            throw new NullPointerException("itemStack is marked non-null but is null");
        }
        ItemMeta meta = itemStack.getItemMeta();
        if (meta instanceof SkullMeta) {
            return ((SkullMeta)meta).getOwner();
        }
        return null;
    }

    public static void setSkullOwner(@NonNull ItemStack itemStack, @NonNull String owner) {
        if (itemStack == null) {
            throw new NullPointerException("itemStack is marked non-null but is null");
        }
        if (owner == null) {
            throw new NullPointerException("owner is marked non-null but is null");
        }
        ItemMeta meta = itemStack.getItemMeta();
        if (meta instanceof SkullMeta) {
            ((SkullMeta)meta).setOwner(owner);
            itemStack.setItemMeta(meta);
            if (Version.before(13)) {
                itemStack.setDurability((short)SkullType.PLAYER.ordinal());
            }
        }
    }

    @Nullable
    public static String getCachedOrFetchFromUsername(String username) {
        return skinService.getSkinTextureByPlayerName(username);
    }

    @Generated
    private SkullUtils() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }

    static {
        initialized = false;
        try {
            if (ReflectionUtil.checkClassExists(RESOLVABLE_PROFILE_CLASS_PATH)) {
                Class<?> resolvableProfileClass = ReflectionUtil.getClass(RESOLVABLE_PROFILE_CLASS_PATH);
                resolvableProfileConstructor = resolvableProfileClass == null ? null : resolvableProfileClass.getConstructor(GameProfile.class);
                gameProfileFieldResolvableProfile = ReflectionUtil.findField(resolvableProfileClass, GameProfile.class);
            }
        }
        catch (NoSuchMethodException noSuchMethodException) {
            // empty catch block
        }
    }
}

