/*
 * Decompiled with CFR 0.152.
 */
package eu.decentsoftware.holograms.libs.xseries.reflection.proxy.processors;

import eu.decentsoftware.holograms.libs.xseries.reflection.ReflectiveHandle;
import eu.decentsoftware.holograms.libs.xseries.reflection.XAccessFlag;
import eu.decentsoftware.holograms.libs.xseries.reflection.jvm.ConstructorMemberHandle;
import eu.decentsoftware.holograms.libs.xseries.reflection.jvm.FieldMemberHandle;
import eu.decentsoftware.holograms.libs.xseries.reflection.jvm.MethodMemberHandle;
import eu.decentsoftware.holograms.libs.xseries.reflection.jvm.classes.ClassHandle;
import eu.decentsoftware.holograms.libs.xseries.reflection.proxy.ReflectiveProxy;
import eu.decentsoftware.holograms.libs.xseries.reflection.proxy.ReflectiveProxyObject;
import eu.decentsoftware.holograms.libs.xseries.reflection.proxy.annotations.Ignore;
import eu.decentsoftware.holograms.libs.xseries.reflection.proxy.processors.ReflectiveAnnotationProcessor;
import java.lang.invoke.MethodHandle;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Executable;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.util.Arrays;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.Set;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@ApiStatus.Internal
public class ReflectiveHandleProxyProcessor {
    public static <T extends ReflectiveProxyObject> T proxify(@NotNull Class<T> interfaceClass, @NotNull ClassHandle targetClass, ReflectiveHandle<?> ... handles) {
        Set remainingHandles = Collections.newSetFromMap(new IdentityHashMap());
        remainingHandles.addAll(Arrays.asList(handles));
        Method[] interfaceMethods = interfaceClass.getMethods();
        IdentityHashMap<Method, ReflectiveProxy.ProxifiedObject> mappedHandles = new IdentityHashMap<Method, ReflectiveProxy.ProxifiedObject>(interfaceMethods.length);
        block2: for (Method method : interfaceMethods) {
            if (ReflectiveAnnotationProcessor.isAnnotationInherited(interfaceClass, method, Ignore.class)) continue;
            String name = method.getName();
            Iterator iter = remainingHandles.iterator();
            while (iter.hasNext()) {
                AccessibleObject constructor;
                ConstructorMemberHandle ctor;
                ReflectiveHandle next = (ReflectiveHandle)iter.next();
                if (next instanceof FieldMemberHandle) {
                    FieldMemberHandle field = (FieldMemberHandle)next;
                    if (!field.getPossibleNames().stream().anyMatch(x -> x.equals(name))) continue;
                    iter.remove();
                    mappedHandles.put(method, new ReflectiveProxy.ProxifiedObject((MethodHandle)field.unreflect(), null, field.getAccessFlags().contains((Object)XAccessFlag.STATIC), false, null, null));
                    continue block2;
                }
                if (next instanceof MethodMemberHandle) {
                    MethodMemberHandle methodHandle = (MethodMemberHandle)next;
                    if (!methodHandle.getPossibleNames().stream().anyMatch(x -> x.equals(name))) continue;
                    iter.remove();
                    mappedHandles.put(method, new ReflectiveProxy.ProxifiedObject((MethodHandle)methodHandle.unreflect(), null, methodHandle.getAccessFlags().contains((Object)XAccessFlag.STATIC), false, null, null));
                    continue block2;
                }
                if (!(next instanceof ConstructorMemberHandle) || method.getReturnType() != interfaceClass || !name.equals(interfaceClass.getName()) || (ctor = (ConstructorMemberHandle)next).getParameterTypes().length != method.getParameterCount()) continue;
                try {
                    constructor = ctor.reflectJvm();
                }
                catch (ReflectiveOperationException e) {
                    throw new IllegalStateException("Failed to map " + method, e);
                }
                int index = 0;
                for (Parameter parameter : method.getParameters()) {
                    if (((Executable)constructor).getParameters()[index].getType() != parameter.getType()) {
                        index = -1;
                        break;
                    }
                    ++index;
                }
                if (index == -1) continue;
                iter.remove();
                mappedHandles.put(method, new ReflectiveProxy.ProxifiedObject((MethodHandle)ctor.unreflect(), null, false, true, null, null));
                continue block2;
            }
        }
        return null;
    }
}

