/*
 * Decompiled with CFR 0.152.
 */
package eu.decentsoftware.holograms.nms.v1_10_R1;

import eu.decentsoftware.holograms.nms.api.NmsHologramPartData;
import eu.decentsoftware.holograms.nms.api.renderer.NmsHeadHologramRenderer;
import eu.decentsoftware.holograms.nms.v1_10_R1.DataWatcherBuilder;
import eu.decentsoftware.holograms.nms.v1_10_R1.EntityIdGenerator;
import eu.decentsoftware.holograms.nms.v1_10_R1.EntityPacketsBuilder;
import eu.decentsoftware.holograms.shared.DecentPosition;
import net.minecraft.server.v1_10_R1.DataWatcher;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;

class HeadHologramRenderer
implements NmsHeadHologramRenderer {
    private final int entityId;
    private final boolean small;
    private final DataWatcher armorStandDataWatcher;

    HeadHologramRenderer(EntityIdGenerator entityIdGenerator) {
        this(entityIdGenerator, false);
    }

    protected HeadHologramRenderer(EntityIdGenerator entityIdGenerator, boolean small) {
        this.entityId = entityIdGenerator.getFreeEntityId();
        this.small = small;
        this.armorStandDataWatcher = DataWatcherBuilder.create().withInvisible().withNoGravity().withArmorStandProperties(small, true).toDataWatcher();
    }

    @Override
    public void display(Player player, NmsHologramPartData<ItemStack> data) {
        DecentPosition position = data.getPosition();
        ItemStack content = data.getContent();
        EntityPacketsBuilder.create().withSpawnEntityLiving(this.entityId, EntityType.ARMOR_STAND, this.offsetPosition(position), this.armorStandDataWatcher).withHelmet(this.entityId, content).sendTo(player);
    }

    @Override
    public void updateContent(Player player, NmsHologramPartData<ItemStack> data) {
        EntityPacketsBuilder.create().withHelmet(this.entityId, data.getContent()).sendTo(player);
    }

    @Override
    public void move(Player player, NmsHologramPartData<ItemStack> data) {
        EntityPacketsBuilder.create().withTeleportEntity(this.entityId, this.offsetPosition(data.getPosition())).sendTo(player);
    }

    @Override
    public void hide(Player player) {
        EntityPacketsBuilder.create().withRemoveEntity(this.entityId).sendTo(player);
    }

    @Override
    public double getHeight(NmsHologramPartData<ItemStack> data) {
        return this.small ? 0.5 : 0.7;
    }

    @Override
    public int[] getEntityIds() {
        return new int[]{this.entityId};
    }

    private DecentPosition offsetPosition(DecentPosition position) {
        double offsetY = this.small ? 1.1875 : 2.0;
        return position.subtractY(offsetY);
    }
}

