/*
 * Decompiled with CFR 0.152.
 */
package eu.decentsoftware.holograms.nms.v1_12_R1;

import eu.decentsoftware.holograms.nms.api.NmsHologramPartData;
import eu.decentsoftware.holograms.nms.api.renderer.NmsTextHologramRenderer;
import eu.decentsoftware.holograms.nms.v1_12_R1.DataWatcherBuilder;
import eu.decentsoftware.holograms.nms.v1_12_R1.EntityIdGenerator;
import eu.decentsoftware.holograms.nms.v1_12_R1.EntityMetadataBuilder;
import eu.decentsoftware.holograms.nms.v1_12_R1.EntityPacketsBuilder;
import eu.decentsoftware.holograms.shared.DecentPosition;
import net.minecraft.server.v1_12_R1.DataWatcher;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Player;

class TextHologramRenderer
implements NmsTextHologramRenderer {
    private final int armorStandEntityId;
    private final DataWatcher dataWatcher;

    TextHologramRenderer(EntityIdGenerator entityIdGenerator) {
        this.armorStandEntityId = entityIdGenerator.getFreeEntityId();
        this.dataWatcher = DataWatcherBuilder.create().withInvisible().withNoGravity().withArmorStandProperties(true, true).toDataWatcher();
    }

    @Override
    public void display(Player player, NmsHologramPartData<String> data) {
        String content = data.getContent();
        DecentPosition position = data.getPosition();
        EntityPacketsBuilder.create().withSpawnEntityLiving(this.armorStandEntityId, EntityType.ARMOR_STAND, this.offsetPosition(position), this.dataWatcher).withEntityMetadata(this.armorStandEntityId, EntityMetadataBuilder.create().withCustomName(content).toWatchableObjects()).sendTo(player);
    }

    @Override
    public void updateContent(Player player, NmsHologramPartData<String> data) {
        EntityPacketsBuilder.create().withEntityMetadata(this.armorStandEntityId, EntityMetadataBuilder.create().withCustomName(data.getContent()).toWatchableObjects()).sendTo(player);
    }

    @Override
    public void move(Player player, NmsHologramPartData<String> data) {
        EntityPacketsBuilder.create().withTeleportEntity(this.armorStandEntityId, this.offsetPosition(data.getPosition())).sendTo(player);
    }

    @Override
    public void hide(Player player) {
        EntityPacketsBuilder.create().withRemoveEntity(this.armorStandEntityId).sendTo(player);
    }

    @Override
    public double getHeight(NmsHologramPartData<String> data) {
        return 0.25;
    }

    @Override
    public int[] getEntityIds() {
        return new int[]{this.armorStandEntityId};
    }

    private DecentPosition offsetPosition(DecentPosition position) {
        return position.subtractY(0.5);
    }
}

