/*
 * Decompiled with CFR 0.152.
 */
package eu.decentsoftware.holograms.nms.v1_18_R1;

import eu.decentsoftware.holograms.nms.api.DecentHologramsNmsException;
import eu.decentsoftware.holograms.nms.api.NmsPacketListener;
import eu.decentsoftware.holograms.nms.api.event.NmsEntityInteractAction;
import eu.decentsoftware.holograms.nms.api.event.NmsEntityInteractEvent;
import eu.decentsoftware.holograms.nms.v1_18_R1.PacketDataSerializerWrapper;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.PacketPlayInUseEntity;
import org.bukkit.entity.Player;

class InboundPacketHandler
extends ChannelInboundHandlerAdapter {
    private final Player player;
    private final NmsPacketListener listener;

    InboundPacketHandler(Player player, NmsPacketListener listener) {
        this.player = player;
        this.listener = listener;
    }

    public void channelRead(ChannelHandlerContext ctx, Object packet) throws Exception {
        if (packet instanceof PacketPlayInUseEntity) {
            PacketPlayInUseEntity packetPlayInUseEntity = (PacketPlayInUseEntity)packet;
            PacketDataSerializerWrapper serializer = PacketDataSerializerWrapper.getInstance();
            serializer.writePacket((Packet<?>)packetPlayInUseEntity);
            int entityId = serializer.readVarInt();
            int actionEnumValueOrdinal = serializer.readVarInt();
            NmsEntityInteractAction action = this.mapActionEnumValueOrdinalToNmsEntityInteractionAction(actionEnumValueOrdinal);
            NmsEntityInteractEvent event = new NmsEntityInteractEvent(this.player, entityId, action);
            this.listener.onEntityInteract(event);
            if (event.isHandled()) {
                return;
            }
        }
        super.channelRead(ctx, packet);
    }

    private NmsEntityInteractAction mapActionEnumValueOrdinalToNmsEntityInteractionAction(int ordinal) {
        return switch (ordinal) {
            case 1 -> {
                if (this.player.isSneaking()) {
                    yield NmsEntityInteractAction.SHIFT_LEFT_CLICK;
                }
                yield NmsEntityInteractAction.LEFT_CLICK;
            }
            case 0, 2 -> {
                if (this.player.isSneaking()) {
                    yield NmsEntityInteractAction.SHIFT_RIGHT_CLICK;
                }
                yield NmsEntityInteractAction.RIGHT_CLICK;
            }
            default -> throw new DecentHologramsNmsException("Unknown entity use action: " + ordinal);
        };
    }
}

