/*
 * Decompiled with CFR 0.152.
 */
package eu.decentsoftware.holograms.nms.v1_8_R2;

import eu.decentsoftware.holograms.nms.v1_8_R2.DataWatcherBuilder;
import eu.decentsoftware.holograms.nms.v1_8_R2.EntityTypeRegistry;
import eu.decentsoftware.holograms.nms.v1_8_R2.PacketDataSerializerWrapper;
import eu.decentsoftware.holograms.shared.DecentPosition;
import eu.decentsoftware.holograms.shared.reflect.ReflectField;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.server.v1_8_R2.DataWatcher;
import net.minecraft.server.v1_8_R2.MathHelper;
import net.minecraft.server.v1_8_R2.Packet;
import net.minecraft.server.v1_8_R2.PacketPlayOutAttachEntity;
import net.minecraft.server.v1_8_R2.PacketPlayOutEntityDestroy;
import net.minecraft.server.v1_8_R2.PacketPlayOutEntityEquipment;
import net.minecraft.server.v1_8_R2.PacketPlayOutEntityHeadRotation;
import net.minecraft.server.v1_8_R2.PacketPlayOutEntityMetadata;
import net.minecraft.server.v1_8_R2.PacketPlayOutEntityTeleport;
import net.minecraft.server.v1_8_R2.PacketPlayOutSpawnEntity;
import net.minecraft.server.v1_8_R2.PacketPlayOutSpawnEntityLiving;
import org.bukkit.craftbukkit.v1_8_R2.CraftEquipmentSlot;
import org.bukkit.craftbukkit.v1_8_R2.entity.CraftPlayer;
import org.bukkit.craftbukkit.v1_8_R2.inventory.CraftItemStack;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Player;
import org.bukkit.inventory.EquipmentSlot;
import org.bukkit.inventory.ItemStack;

class EntityPacketsBuilder {
    private static final ReflectField<DataWatcher> SPAWN_ENTITY_LIVING_PACKET_DATA_WATCHER_FIELD = new ReflectField(PacketPlayOutSpawnEntityLiving.class, "l");
    private final List<Packet<?>> packets = new ArrayList();
    private final DataWatcher emptyDataWatcher = DataWatcherBuilder.create().withEmptyEntityProperties().toDataWatcher();

    private EntityPacketsBuilder() {
    }

    void sendTo(Player player) {
        for (Packet<?> packet : this.packets) {
            this.sendPacket(player, packet);
        }
    }

    EntityPacketsBuilder withSpawnEntityLivingOrObject(int entityId, EntityType type, DecentPosition position) {
        if (type.isAlive()) {
            return this.withSpawnEntityLiving(entityId, type, position);
        }
        return this.withSpawnEntity(entityId, type, position);
    }

    EntityPacketsBuilder withSpawnEntity(int entityId, EntityType type, DecentPosition position) {
        PacketDataSerializerWrapper serializer = this.prepareSpawnEntityData(entityId, type, position);
        serializer.writeInt(type == EntityType.DROPPED_ITEM ? 1 : 0);
        serializer.writeShort(0);
        serializer.writeShort(0);
        serializer.writeShort(0);
        PacketPlayOutSpawnEntity packet = new PacketPlayOutSpawnEntity();
        serializer.writeToPacket((Packet<?>)packet);
        this.packets.add((Packet<?>)packet);
        return this;
    }

    EntityPacketsBuilder withSpawnEntityLiving(int entityId, EntityType type, DecentPosition position) {
        return this.withSpawnEntityLiving(entityId, type, position, this.emptyDataWatcher);
    }

    EntityPacketsBuilder withSpawnEntityLiving(int entityId, EntityType type, DecentPosition position, DataWatcher dataWatcher) {
        PacketDataSerializerWrapper serializer = this.prepareSpawnEntityData(entityId, type, position);
        serializer.writeByte(MathHelper.d((float)(position.getYaw() * 256.0f / 360.0f)));
        serializer.writeShort(0);
        serializer.writeShort(0);
        serializer.writeShort(0);
        serializer.writeByte(127);
        PacketPlayOutSpawnEntityLiving packet = new PacketPlayOutSpawnEntityLiving();
        serializer.writeToPacket((Packet<?>)packet);
        SPAWN_ENTITY_LIVING_PACKET_DATA_WATCHER_FIELD.set(packet, dataWatcher);
        this.packets.add((Packet<?>)packet);
        return this;
    }

    private PacketDataSerializerWrapper prepareSpawnEntityData(int entityId, EntityType type, DecentPosition position) {
        PacketDataSerializerWrapper serializer = PacketDataSerializerWrapper.getInstance();
        serializer.writeVarInt(entityId);
        serializer.writeByte(EntityTypeRegistry.getEntityTypeId(type));
        serializer.writeInt(MathHelper.floor((double)(position.getX() * 32.0)));
        serializer.writeInt(MathHelper.floor((double)(position.getY() * 32.0)));
        serializer.writeInt(MathHelper.floor((double)(position.getZ() * 32.0)));
        serializer.writeByte(MathHelper.d((float)(position.getYaw() * 256.0f / 360.0f)));
        serializer.writeByte(MathHelper.d((float)(position.getPitch() * 256.0f / 360.0f)));
        return serializer;
    }

    EntityPacketsBuilder withEntityMetadata(int entityId, List<DataWatcher.WatchableObject> watchableObjects) {
        PacketDataSerializerWrapper serializer = PacketDataSerializerWrapper.getInstance();
        serializer.writeVarInt(entityId);
        serializer.writeWatchableObjects(watchableObjects);
        PacketPlayOutEntityMetadata packet = new PacketPlayOutEntityMetadata();
        serializer.writeToPacket((Packet<?>)packet);
        this.packets.add((Packet<?>)packet);
        return this;
    }

    EntityPacketsBuilder withHelmet(int entityId, ItemStack itemStack) {
        PacketPlayOutEntityEquipment packet = new PacketPlayOutEntityEquipment(entityId, CraftEquipmentSlot.getSlotIndex((EquipmentSlot)EquipmentSlot.HEAD), this.itemStackToNms(itemStack));
        this.packets.add((Packet<?>)packet);
        return this;
    }

    EntityPacketsBuilder withTeleportEntity(int entityId, DecentPosition position) {
        PacketPlayOutEntityTeleport packet = new PacketPlayOutEntityTeleport(entityId, MathHelper.floor((double)(position.getX() * 32.0)), MathHelper.floor((double)(position.getY() * 32.0)), MathHelper.floor((double)(position.getZ() * 32.0)), (byte)(position.getYaw() * 256.0f / 360.0f), (byte)(position.getPitch() * 256.0f / 360.0f), false);
        this.packets.add((Packet<?>)packet);
        return this;
    }

    EntityPacketsBuilder withEntityHeadLook(int entityId, float yaw) {
        PacketDataSerializerWrapper serializer = PacketDataSerializerWrapper.getInstance();
        serializer.writeVarInt(entityId);
        serializer.writeByte((byte)(yaw * 256.0f / 360.0f));
        PacketPlayOutEntityHeadRotation packet = new PacketPlayOutEntityHeadRotation();
        serializer.writeToPacket((Packet<?>)packet);
        this.packets.add((Packet<?>)packet);
        return this;
    }

    EntityPacketsBuilder attachEntity(int attachedEntityId, int vehicleEntityId) {
        return this.updatePassenger(attachedEntityId, vehicleEntityId);
    }

    EntityPacketsBuilder unattachEntity(int attachedEntityId) {
        return this.updatePassenger(attachedEntityId, -1);
    }

    private EntityPacketsBuilder updatePassenger(int attachedEntityId, int vehicleEntityId) {
        PacketDataSerializerWrapper serializer = PacketDataSerializerWrapper.getInstance();
        serializer.writeInt(attachedEntityId);
        serializer.writeInt(vehicleEntityId);
        serializer.writeByte(0);
        PacketPlayOutAttachEntity packet = new PacketPlayOutAttachEntity();
        serializer.writeToPacket((Packet<?>)packet);
        this.packets.add((Packet<?>)packet);
        return this;
    }

    EntityPacketsBuilder withRemoveEntity(int entityId) {
        PacketPlayOutEntityDestroy packet = new PacketPlayOutEntityDestroy(new int[]{entityId});
        this.packets.add((Packet<?>)packet);
        return this;
    }

    private void sendPacket(Player player, Packet<?> packet) {
        ((CraftPlayer)player).getHandle().playerConnection.sendPacket(packet);
    }

    private net.minecraft.server.v1_8_R2.ItemStack itemStackToNms(ItemStack itemStack) {
        return CraftItemStack.asNMSCopy((ItemStack)itemStack);
    }

    static EntityPacketsBuilder create() {
        return new EntityPacketsBuilder();
    }
}

